/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import org.epics.graphene.AreaGraph2DRendererUpdate;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Graph2DRenderer;

public class AreaGraph2DRenderer
extends Graph2DRenderer<AreaGraph2DRendererUpdate> {
    private static final AxisRange DEFAULT_X_RANGE = AxisRanges.relative();
    private static final AxisRange DEFAULT_Y_RANGE = AxisRanges.display();
    private Integer focusPixelX;
    private Integer focusValueIndex;
    private boolean highlightFocusValue = false;

    public AreaGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
        super.update(((AreaGraph2DRendererUpdate)new AreaGraph2DRendererUpdate().xAxisRange(DEFAULT_X_RANGE)).yAxisRange(DEFAULT_Y_RANGE));
    }

    @Override
    public AreaGraph2DRendererUpdate newUpdate() {
        return new AreaGraph2DRendererUpdate();
    }

    @Override
    public void update(AreaGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getFocusPixelX() != null) {
            this.focusPixelX = update.getFocusPixelX();
        }
        if (update.getHighlightFocusValue() != null) {
            this.highlightFocusValue = update.getHighlightFocusValue();
        }
    }

    public void draw(Graphics2D graphics, Cell1DDataset dataset) {
        Color dividerColor = new Color(196, 196, 196);
        Color lineColor = new Color(140, 140, 140);
        Color histogramColor = new Color(175, 175, 175);
        this.g = graphics;
        this.referenceLineColor = this.backgroundColor;
        this.calculateRanges(dataset.getXRange(), dataset.getStatistics());
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        int[] binLimitsPx = new int[dataset.getXCount() + 1];
        int[] binHeightsPx = new int[dataset.getXCount()];
        this.focusValueIndex = null;
        for (int i = 0; i < dataset.getXCount(); ++i) {
            binLimitsPx[i] = (int)this.scaledX(dataset.getXBoundaries().getDouble(i));
            binHeightsPx[i] = (int)this.scaledY(dataset.getValue(i));
            if (this.focusPixelX == null || binLimitsPx[i] >= this.focusPixelX) continue;
            this.focusValueIndex = i;
        }
        binLimitsPx[dataset.getXCount()] = (int)this.scaledX(dataset.getXBoundaries().getDouble(dataset.getXCount()));
        int plotStart = (int)this.scaledY(this.getYPlotRange().getMinimum().doubleValue());
        for (int i = 0; i < binHeightsPx.length; ++i) {
            graphics.setColor(histogramColor);
            if (!this.highlightFocusValue || this.focusValueIndex == null || i != this.focusValueIndex) {
                graphics.fillRect(binLimitsPx[i], binHeightsPx[i], binLimitsPx[i + 1] - binLimitsPx[i], plotStart - binHeightsPx[i]);
            }
            graphics.setColor(dividerColor);
            if (plotStart - binHeightsPx[i] <= 0) continue;
            graphics.drawLine(binLimitsPx[i], binHeightsPx[i], binLimitsPx[i], plotStart);
        }
        graphics.setColor(this.backgroundColor);
        this.drawHorizontalReferenceLines();
        int previousHeight = plotStart;
        for (int i = 0; i < binHeightsPx.length; ++i) {
            graphics.setColor(lineColor);
            graphics.drawLine(binLimitsPx[i], previousHeight, binLimitsPx[i], binHeightsPx[i]);
            graphics.drawLine(binLimitsPx[i], binHeightsPx[i], binLimitsPx[i + 1], binHeightsPx[i]);
            previousHeight = binHeightsPx[i];
        }
        if (previousHeight > 0) {
            graphics.drawLine(binLimitsPx[binLimitsPx.length - 1], previousHeight, binLimitsPx[binLimitsPx.length - 1], plotStart);
        }
    }

    public Integer getFocusPixelX() {
        return this.focusPixelX;
    }

    public Integer getFocusValueIndex() {
        return this.focusValueIndex;
    }
}

