/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRangeInstance;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;

public class AxisRanges {
    private AxisRanges() {
    }

    public static AxisRange absolute(double min, double max) {
        final Range absoluteRange = RangeUtil.range(min, max);
        return new AxisRange(){
            private final AxisRange axisRange = this;

            @Override
            public AxisRangeInstance createInstance() {
                return new AxisRangeInstance(){

                    @Override
                    public Range axisRange(Range dataRange, Range displayRange) {
                        return absoluteRange;
                    }

                    @Override
                    public AxisRange getAxisRange() {
                        return axisRange;
                    }
                };
            }
        };
    }

    public static AxisRange relative() {
        return new AxisRange(){
            private final AxisRange axisRange = this;

            @Override
            public AxisRangeInstance createInstance() {
                return new AxisRangeInstance(){

                    @Override
                    public Range axisRange(Range dataRange, Range displayRange) {
                        return dataRange;
                    }

                    @Override
                    public AxisRange getAxisRange() {
                        return axisRange;
                    }
                };
            }
        };
    }

    public static AxisRange integrated() {
        return new AxisRange(){
            private final AxisRange axisRange = this;

            @Override
            public AxisRangeInstance createInstance() {
                return new AxisRangeInstance(){
                    Range aggregatedRange;

                    @Override
                    public Range axisRange(Range dataRange, Range displayRange) {
                        this.aggregatedRange = RangeUtil.aggregateRange(dataRange, this.aggregatedRange);
                        return this.aggregatedRange;
                    }

                    @Override
                    public AxisRange getAxisRange() {
                        return axisRange;
                    }
                };
            }
        };
    }

    public static AxisRange display() {
        return new AxisRange(){
            private final AxisRange axisRange = this;

            @Override
            public AxisRangeInstance createInstance() {
                return new AxisRangeInstance(){

                    @Override
                    public Range axisRange(Range dataRange, Range displayRange) {
                        return displayRange;
                    }

                    @Override
                    public AxisRange getAxisRange() {
                        return axisRange;
                    }
                };
            }
        };
    }
}

