/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.MathUtil;
import org.epics.graphene.Point1DDataset;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;

class Cell1DHistogramDataset
implements Cell1DDataset {
    private Statistics statistics;
    private Range xRange;
    private ListDouble xBoundaries;
    private double minValueRange;
    private double maxValueRange;
    private int minCountRange;
    private int maxCountRange;
    private double[] binValueBoundary;
    private double[] values;
    private boolean autoValueRange = true;
    private int nBins = 100;

    public Cell1DHistogramDataset(Point1DDataset dataset) {
        this.calculateFrom(dataset);
    }

    private void calculateFrom(Point1DDataset dataset) {
        if (dataset.getStatistics() == null) {
            throw new NullPointerException("dataset is null");
        }
        IteratorNumber newValues = dataset.getValues().iterator();
        if (this.autoValueRange) {
            this.minValueRange = dataset.getStatistics().getMinimum().doubleValue();
            this.maxValueRange = dataset.getStatistics().getMaximum().doubleValue();
            this.binValueBoundary = RangeUtil.createBins(this.minValueRange, this.maxValueRange, this.nBins);
            this.xBoundaries = new ArrayDouble(this.binValueBoundary);
            this.xRange = RangeUtil.range(this.binValueBoundary[0], this.binValueBoundary[this.nBins]);
        }
        this.values = new double[this.nBins];
        while (newValues.hasNext()) {
            this.addValueToBin(newValues.nextDouble());
        }
        this.statistics = StatisticsUtil.statisticsOf((CollectionNumber)new ArrayDouble(this.values));
    }

    private void addValueToBin(double value) {
        if (!RangeUtil.contains(this.xRange, value)) {
            return;
        }
        int bin = (int)Math.floor(MathUtil.scale(value, this.xRange.getMinimum().doubleValue(), this.xRange.getMaximum().doubleValue(), this.nBins));
        if (bin == this.nBins) {
            // empty if block
        }
        int n = --bin;
        this.values[n] = this.values[n] + 1.0;
    }

    @Override
    public double getValue(int x) {
        return this.values[x];
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public ListNumber getXBoundaries() {
        return this.xBoundaries;
    }

    @Override
    public Range getXRange() {
        return this.xRange;
    }

    @Override
    public int getXCount() {
        return this.values.length;
    }
}

