/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import org.epics.graphene.AxisRange;
import org.epics.graphene.ValueScale;

public class Graph2DRendererUpdate<T extends Graph2DRendererUpdate<T>> {
    private Integer imageHeight;
    private Integer imageWidth;
    private AxisRange xAxisRange;
    private AxisRange yAxisRange;
    private ValueScale xValueScale;
    private ValueScale yValueScale;
    private Color backgroundColor;
    private Color labelColor;
    private Color referenceLineColor;
    private Font labelFont;
    private Integer bottomMargin;
    private Integer topMargin;
    private Integer leftMargin;
    private Integer rightMargin;
    private Integer bottomAreaMargin;
    private Integer topAreaMargin;
    private Integer leftAreaMargin;
    private Integer rightAreaMargin;
    private Integer xLabelMargin;
    private Integer yLabelMargin;

    protected T self() {
        return (T)this;
    }

    public T imageHeight(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Image height must be a postive non-zero integer.");
        }
        this.imageHeight = height;
        return this.self();
    }

    public T imageWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Image width must be a postive non-zero integer.");
        }
        this.imageWidth = width;
        return this.self();
    }

    public T xAxisRange(AxisRange xAxisRange) {
        this.xAxisRange = xAxisRange;
        return this.self();
    }

    public T yAxisRange(AxisRange yAxisRange) {
        this.yAxisRange = yAxisRange;
        return this.self();
    }

    public T xValueScale(ValueScale xValueScale) {
        this.xValueScale = xValueScale;
        return this.self();
    }

    public T yValueScale(ValueScale yValueScale) {
        this.yValueScale = yValueScale;
        return this.self();
    }

    public T backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this.self();
    }

    public T labelColor(Color labelColor) {
        this.labelColor = labelColor;
        return this.self();
    }

    public T referenceLineColor(Color referenceLineColor) {
        this.referenceLineColor = referenceLineColor;
        return this.self();
    }

    public T labelFont(Font labelFont) {
        this.labelFont = labelFont;
        return this.self();
    }

    public T bottomMargin(int bottomMargin) {
        if (bottomMargin < 0) {
            throw new IllegalArgumentException("The bottom margin must be a non-negative integer.");
        }
        this.bottomMargin = bottomMargin;
        return this.self();
    }

    public T topMargin(int topMargin) {
        if (topMargin < 0) {
            throw new IllegalArgumentException("The top margin must be a non-negative integer.");
        }
        this.topMargin = topMargin;
        return this.self();
    }

    public T leftMargin(int leftMargin) {
        if (leftMargin < 0) {
            throw new IllegalArgumentException("The left margin must be a non-negative integer.");
        }
        this.leftMargin = leftMargin;
        return this.self();
    }

    public T rightMargin(int rightMargin) {
        if (rightMargin < 0) {
            throw new IllegalArgumentException("The right margin must be a non-negative integer.");
        }
        this.rightMargin = rightMargin;
        return this.self();
    }

    public T allMargins(int marginSize) {
        if (marginSize < 0) {
            throw new IllegalArgumentException("The margin size must be a non-negative integer.");
        }
        this.bottomMargin = marginSize;
        this.topMargin = marginSize;
        this.leftMargin = marginSize;
        this.rightMargin = marginSize;
        return this.self();
    }

    public T bottomAreaMargin(int bottomAreaMargin) {
        if (bottomAreaMargin < 0) {
            throw new IllegalArgumentException("The bottomArea margin must be a non-negative integer.");
        }
        this.bottomAreaMargin = bottomAreaMargin;
        return this.self();
    }

    public T topAreaMargin(int topAreaMargin) {
        if (topAreaMargin < 0) {
            throw new IllegalArgumentException("The topArea margin must be a non-negative integer.");
        }
        this.topAreaMargin = topAreaMargin;
        return this.self();
    }

    public T leftAreaMargin(int leftAreaMargin) {
        if (leftAreaMargin < 0) {
            throw new IllegalArgumentException("The leftArea margin must be a non-negative integer.");
        }
        this.leftAreaMargin = leftAreaMargin;
        return this.self();
    }

    public T rightAreaMargin(int rightAreaMargin) {
        if (rightAreaMargin < 0) {
            throw new IllegalArgumentException("The rightArea margin must be a non-negative integer.");
        }
        this.rightAreaMargin = rightAreaMargin;
        return this.self();
    }

    public T allAreaMargins(int areaMarginSize) {
        if (areaMarginSize < 0) {
            throw new IllegalArgumentException("The area margin size must be a non-negative integer.");
        }
        this.topAreaMargin = areaMarginSize;
        this.bottomAreaMargin = areaMarginSize;
        this.leftAreaMargin = areaMarginSize;
        this.rightAreaMargin = areaMarginSize;
        return this.self();
    }

    public T xLabelMargin(int xLabelMargin) {
        if (xLabelMargin < 0) {
            throw new IllegalArgumentException("The xLabel margin must be a non-negative integer.");
        }
        this.xLabelMargin = xLabelMargin;
        return this.self();
    }

    public T yLabelMargin(int yLabelMargin) {
        if (yLabelMargin < 0) {
            throw new IllegalArgumentException("The yLabel margin must be a non-negative integer.");
        }
        this.yLabelMargin = yLabelMargin;
        return this.self();
    }

    public T allLabelMargins(int labelMarginSize) {
        if (labelMarginSize < 0) {
            throw new IllegalArgumentException("The label margin size must be a non-negative integer.");
        }
        this.xLabelMargin = labelMarginSize;
        this.yLabelMargin = labelMarginSize;
        return this.self();
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public AxisRange getXAxisRange() {
        return this.xAxisRange;
    }

    public AxisRange getYAxisRange() {
        return this.yAxisRange;
    }

    public ValueScale getXValueScale() {
        return this.xValueScale;
    }

    public ValueScale getYValueScale() {
        return this.yValueScale;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public Color getReferenceLineColor() {
        return this.referenceLineColor;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Integer getBottomMargin() {
        return this.bottomMargin;
    }

    public Integer getTopMargin() {
        return this.topMargin;
    }

    public Integer getLeftMargin() {
        return this.leftMargin;
    }

    public Integer getRightMargin() {
        return this.rightMargin;
    }

    public Integer getBottomAreaMargin() {
        return this.bottomAreaMargin;
    }

    public Integer getTopAreaMargin() {
        return this.topAreaMargin;
    }

    public Integer getLeftAreaMargin() {
        return this.leftAreaMargin;
    }

    public Integer getRightAreaMargin() {
        return this.rightAreaMargin;
    }

    public Integer getXLabelMargin() {
        return this.xLabelMargin;
    }

    public Integer getYLabelMargin() {
        return this.yLabelMargin;
    }
}

