/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.List;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.Range;
import org.epics.graphene.ValueScale;
import org.epics.util.array.ListInt;

public class GraphBuffer {
    private final BufferedImage image;
    private final Graphics2D g;
    private final byte[] pixels;
    private final boolean hasAlphaChannel;
    private final int width;
    private final int height;
    private double xLeftValue;
    private double xRightValue;
    private double xLeftPixel;
    private double xRightPixel;
    private ValueScale xValueScale;
    private double yTopValue;
    private double yBottomValue;
    private double yTopPixel;
    private double yBottomPixel;
    private ValueScale yValueScale;
    private static final int MIN = 0;
    private static final int MAX = 1;

    private GraphBuffer(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        this.hasAlphaChannel = image.getAlphaRaster() != null;
        this.g = image.createGraphics();
    }

    public GraphBuffer(int width, int height) {
        this(new BufferedImage(width, height, 5));
    }

    public GraphBuffer(Graph2DRenderer<?> renderer) {
        this(renderer.getImageWidth(), renderer.getImageHeight());
    }

    public void setPixel(int x, int y, int color) {
        if (this.hasAlphaChannel) {
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 3] = (byte)(color >> 24 & 0xFF);
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 0] = (byte)(color >> 0 & 0xFF);
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 1] = (byte)(color >> 8 & 0xFF);
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 2] = (byte)(color >> 16 & 0xFF);
        } else {
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 0] = (byte)(color >> 0 & 0xFF);
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 1] = (byte)(color >> 8 & 0xFF);
            this.pixels[y * this.image.getWidth() * 4 + x * 4 + 2] = (byte)(color >> 16 & 0xFF);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Graphics2D getGraphicsContext() {
        return this.g;
    }

    public void drawDataImage(int xStartPoint, int yStartPoint, int[] xPointToDataMap, int[] yPointToDataMap, Cell2DDataset data, NumberColorMapInstance colorMap) {
        int previousYData = -1;
        for (int yOffset = 0; yOffset < yPointToDataMap.length; ++yOffset) {
            int yData = yPointToDataMap[yOffset];
            if (yData != previousYData) {
                for (int xOffset = 0; xOffset < xPointToDataMap.length; ++xOffset) {
                    int xData = xPointToDataMap[xOffset];
                    int rgb = colorMap.colorFor(data.getValue(xData, yData));
                    if (this.hasAlphaChannel) {
                        this.pixels[(yStartPoint + yOffset) * this.width * 4 + 4 * (xStartPoint + xOffset) + 0] = (byte)(rgb >> 24 & 0xFF);
                        this.pixels[(yStartPoint + yOffset) * this.width * 4 + 4 * (xStartPoint + xOffset) + 1] = (byte)(rgb & 0xFF);
                        this.pixels[(yStartPoint + yOffset) * this.width * 4 + 4 * (xStartPoint + xOffset) + 2] = (byte)(rgb >> 8 & 0xFF);
                        this.pixels[(yStartPoint + yOffset) * this.width * 4 + 4 * (xStartPoint + xOffset) + 3] = (byte)(rgb >> 16 & 0xFF);
                        continue;
                    }
                    this.pixels[(yStartPoint + yOffset) * this.width * 3 + 3 * (xStartPoint + xOffset) + 0] = (byte)(rgb & 0xFF);
                    this.pixels[(yStartPoint + yOffset) * this.width * 3 + 3 * (xStartPoint + xOffset) + 1] = (byte)(rgb >> 8 & 0xFF);
                    this.pixels[(yStartPoint + yOffset) * this.width * 3 + 3 * (xStartPoint + xOffset) + 2] = (byte)(rgb >> 16 & 0xFF);
                }
            } else if (this.hasAlphaChannel) {
                System.arraycopy(this.pixels, (yStartPoint + yOffset - 1) * this.width * 4 + 4 * xStartPoint, this.pixels, (yStartPoint + yOffset) * this.width * 4 + 4 * xStartPoint, xPointToDataMap.length * 4);
            } else {
                System.arraycopy(this.pixels, (yStartPoint + yOffset - 1) * this.width * 3 + 3 * xStartPoint, this.pixels, (yStartPoint + yOffset) * this.width * 3 + 3 * xStartPoint, xPointToDataMap.length * 3);
            }
            previousYData = yData;
        }
    }

    public void setXScaleAsCell(Range range, int xMinPixel, int xMaxPixel, ValueScale xValueScale) {
        this.xLeftValue = range.getMinimum().doubleValue();
        this.xRightValue = range.getMaximum().doubleValue();
        this.xLeftPixel = xMinPixel;
        this.xRightPixel = xMaxPixel + 1;
        this.xValueScale = xValueScale;
    }

    public void setXScaleAsPoint(Range range, int xMinPixel, int xMaxPixel, ValueScale xValueScale) {
        this.xLeftValue = range.getMinimum().doubleValue();
        this.xRightValue = range.getMaximum().doubleValue();
        this.xLeftPixel = (double)xMinPixel + 0.5;
        this.xRightPixel = (double)xMaxPixel + 0.5;
        this.xValueScale = xValueScale;
    }

    public int xValueToPixel(double value) {
        return (int)this.xValueScale.scaleValue(value, this.xLeftValue, this.xRightValue, this.xLeftPixel, this.xRightPixel);
    }

    public void setYScaleAsCell(Range range, int yMinPixel, int yMaxPixel, ValueScale yValueScale) {
        this.yTopValue = range.getMaximum().doubleValue();
        this.yBottomValue = range.getMinimum().doubleValue();
        this.yTopPixel = yMaxPixel - 1;
        this.yBottomPixel = yMinPixel;
        this.yValueScale = yValueScale;
    }

    public void setYScaleAsPoint(Range range, int yMinPixel, int yMaxPixel, ValueScale yValueScale) {
        this.yTopValue = range.getMaximum().doubleValue();
        this.yBottomValue = range.getMinimum().doubleValue();
        this.yTopPixel = (double)yMaxPixel - 0.5;
        this.yBottomPixel = (double)yMinPixel - 0.5;
        this.yValueScale = yValueScale;
    }

    public int yValueToPixel(double value) {
        return (int)Math.ceil(this.yValueScale.scaleValue(value, this.yBottomValue, this.yTopValue, this.yBottomPixel, this.yTopPixel));
    }

    void drawBackground(Color color) {
        this.g.setColor(color);
        this.g.fillRect(0, 0, this.width, this.height);
    }

    void drawBottomLabels(List<String> labels, ListInt valuePixelPositions, Color labelColor, Font labelFont, int leftPixel, int rightPixel, int topPixel) {
        if (labels != null && !labels.isEmpty()) {
            this.g.setColor(labelColor);
            this.g.setFont(labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{leftPixel, rightPixel};
            GraphBuffer.drawLineLabel(this.g, metrics, labels.get(0), valuePixelPositions.getInt(0), drawRange, topPixel, true, false);
            GraphBuffer.drawLineLabel(this.g, metrics, labels.get(labels.size() - 1), valuePixelPositions.getInt(labels.size() - 1), drawRange, topPixel, false, false);
            for (int i = 1; i < labels.size() - 1; ++i) {
                GraphBuffer.drawLineLabel(this.g, metrics, labels.get(i), valuePixelPositions.getInt(i), drawRange, topPixel, true, false);
            }
        }
    }

    private static void drawLineLabel(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    void drawLeftLabels(List<String> labels, ListInt valuePixelPositions, Color labelColor, Font labelFont, int bottomPixel, int topPixel, int leftPixel) {
        if (labels != null && !labels.isEmpty()) {
            this.g.setColor(labelColor);
            this.g.setFont(labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{topPixel, bottomPixel};
            GraphBuffer.drawColumnLabel(this.g, metrics, labels.get(0), valuePixelPositions.getInt(0), drawRange, leftPixel, true, false);
            GraphBuffer.drawColumnLabel(this.g, metrics, labels.get(labels.size() - 1), valuePixelPositions.getInt(labels.size() - 1), drawRange, leftPixel, false, false);
            for (int i = 1; i < labels.size() - 1; ++i) {
                GraphBuffer.drawColumnLabel(this.g, metrics, labels.get(i), valuePixelPositions.getInt(i), drawRange, leftPixel, true, false);
            }
        }
    }

    private static void drawColumnLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    void drawHorizontalReferenceLines(ListInt referencePixels, Color lineColor, int graphLeftPixel, int graphRightPixel) {
        this.g.setColor(lineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int i = 0; i < referencePixels.size(); ++i) {
            this.g.drawLine(graphLeftPixel, referencePixels.getInt(i), graphRightPixel, referencePixels.getInt(i));
        }
    }

    void drawVerticalReferenceLines(ListInt referencePixels, Color lineColor, int graphBottomPixel, int graphTopPixel) {
        this.g.setColor(lineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int i = 0; i < referencePixels.size(); ++i) {
            this.g.drawLine(referencePixels.getInt(i), graphTopPixel, referencePixels.getInt(i), graphBottomPixel);
        }
    }
}

