/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.epics.graphene.FontUtil;
import org.epics.graphene.MathUtil;
import org.epics.graphene.ValueAxis;

class HorizontalAxisRenderer {
    private ValueAxis axis;
    private static Font defaultAxisFont = FontUtil.getLiberationSansRegular();
    private Font axisFont = defaultAxisFont;
    private int axisHeight;
    private int bottomMargin = 3;
    private int tickSize = 3;
    private int textTickMargin = 0;
    private String[] xLabels;
    private double[] xValueTicks;
    private int[] xTicks;
    private Color axisColor = new Color(192, 192, 192);
    private Color axisTickColor = Color.BLACK;
    private Color axisTextColor = Color.BLACK;
    private FontMetrics metrics;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int marginBetweenXLabels = 4;

    HorizontalAxisRenderer(ValueAxis valueAxis, int bottomMargin, Graphics2D graphics) {
        this.axis = valueAxis;
        this.bottomMargin = bottomMargin;
        this.metrics = graphics.getFontMetrics(this.axisFont);
        this.xValueTicks = this.axis.getTickValues();
        this.xLabels = this.axis.getTickLabels();
        int[] xLabelWidths = new int[this.xLabels.length];
        for (int i = 0; i < xLabelWidths.length; ++i) {
            xLabelWidths[i] = this.metrics.stringWidth(this.xLabels[i]);
        }
        this.axisHeight = bottomMargin + this.metrics.getHeight() - this.metrics.getLeading() + this.textTickMargin + this.tickSize;
    }

    public void draw(Graphics2D graphics, int startImage, int startAxis, int endAxis, int endImage, int axisPosition) {
        int plotWidth = endAxis - startAxis;
        int imageWidth = endImage - startImage;
        int imageHeight = axisPosition + this.getAxisHeight();
        this.xTicks = new int[this.xLabels.length];
        for (int i = 0; i < this.xTicks.length; ++i) {
            this.xTicks[i] = startAxis + (int)(MathUtil.normalize(this.xValueTicks[i], this.axis.getMinValue(), this.axis.getMaxValue()) * (double)plotWidth);
        }
        graphics.setColor(this.axisColor);
        graphics.setFont(this.axisFont);
        graphics.drawLine(startAxis, imageHeight - this.getAxisHeight(), startAxis + plotWidth, imageHeight - this.getAxisHeight());
        int[] drawRange = new int[]{0, imageWidth};
        graphics.setColor(this.axisTextColor);
        HorizontalAxisRenderer.drawCenteredText(graphics, this.metrics, this.xLabels[0], this.xTicks[0], drawRange, imageHeight - this.bottomMargin, true, false);
        HorizontalAxisRenderer.drawCenteredText(graphics, this.metrics, this.xLabels[this.xLabels.length - 1], this.xTicks[this.xLabels.length - 1], drawRange, imageHeight - this.bottomMargin, false, false);
        for (int i = 0; i < this.xLabels.length; ++i) {
            graphics.setColor(this.axisTextColor);
            HorizontalAxisRenderer.drawCenteredText(graphics, this.metrics, this.xLabels[i], this.xTicks[i], drawRange, imageHeight - this.bottomMargin, true, true);
            graphics.setColor(this.axisTickColor);
            graphics.drawLine(this.xTicks[i], imageHeight - this.getAxisHeight(), this.xTicks[i], imageHeight - this.getAxisHeight() + this.tickSize);
        }
    }

    public int getAxisHeight() {
        return this.axisHeight;
    }

    private static void drawCenteredText(Graphics2D graphics, FontMetrics metrics, String text, int center, int[] drawRange, int y, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < center || drawRange[0] > center) {
            return;
        }
        double width = metrics.getStringBounds(text, graphics).getWidth();
        if ((double)(drawRange[1] - drawRange[0]) < width) {
            return;
        }
        int targetX = center - (int)(width / 2.0);
        if (targetX < drawRange[0]) {
            if (centeredOnly) {
                return;
            }
            targetX = drawRange[0];
        } else if ((double)targetX + width > (double)drawRange[1]) {
            if (centeredOnly) {
                return;
            }
            targetX = drawRange[1] - (int)width;
        }
        graphics.drawString(text, targetX, y);
        if (updateMin) {
            drawRange[0] = targetX + (int)width + 4;
        } else {
            drawRange[1] = targetX - 4;
        }
    }

    public int[] horizontalTickPositions() {
        return this.xTicks;
    }
}

