/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.AxisRangeInstance;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Cell2DDatasets;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.GraphAreaData;
import org.epics.graphene.GraphBuffer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.NumberColorMaps;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;

public class IntensityGraph2DRenderer
extends Graph2DRenderer<IntensityGraph2DRendererUpdate> {
    public static NumberColorMap DEFAULT_COLOR_MAP = NumberColorMaps.JET;
    public static boolean DEFAULT_DRAW_LEGEND = false;
    private NumberColorMapInstance colorMapInstance;
    private Range optimizedRange;
    private boolean optimizeColorScheme = true;
    private int legendWidth = 10;
    private int legendMarginToGraph = 10;
    private int graphAreaToLegendMargin = 3;
    protected int zLabelMargin = 3;
    private boolean drawLegend = DEFAULT_DRAW_LEGEND;
    private Range zRange;
    private Range zAggregatedRange;
    private Range zPlotRange;
    private AxisRangeInstance zAxisRange = AxisRanges.display().createInstance();
    private ValueScale zValueScale = ValueScales.linearScale();
    protected ListInt zReferenceCoords;
    protected ListDouble zReferenceValues;
    protected List<String> zReferenceLabels;
    private int zLabelMaxWidth;
    private int originalRightMargin = this.rightMargin;
    public boolean useColorArray = false;
    private NumberColorMap colorMap = DEFAULT_COLOR_MAP;

    public IntensityGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public IntensityGraph2DRenderer() {
        this(300, 200);
    }

    @Override
    public void update(IntensityGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getDrawLegend() != null) {
            this.drawLegend = update.getDrawLegend();
        }
        if (update.getColorMap() != null) {
            this.colorMap = update.getColorMap();
            this.colorMapInstance = null;
        }
        if (update.getZLabelMargin() != null) {
            this.zLabelMargin = update.getZLabelMargin();
        }
        if (update.getLegendWidth() != null) {
            this.legendWidth = update.getLegendWidth();
        }
        if (update.getGraphAreaToLegendMargin() != null) {
            this.graphAreaToLegendMargin = update.getGraphAreaToLegendMargin();
        }
        if (update.getRightMargin() != null) {
            this.originalRightMargin = update.getRightMargin();
        }
    }

    public void draw(GraphBuffer graphBuffer, Cell2DDataset data) {
        int areaRightPixel;
        this.g = graphBuffer.getGraphicsContext();
        GraphAreaData area = new GraphAreaData();
        BufferedImage image = graphBuffer.getImage();
        this.calculateRanges(data.getXRange(), data.getYRange());
        area.setGraphBuffer(graphBuffer);
        graphBuffer.drawBackground(this.backgroundColor);
        this.calculateZRange(data.getStatistics(), data.getDisplayRange());
        if (this.drawLegend) {
            this.calculateZLabels();
            areaRightPixel = this.getImageWidth() - 1 - (this.graphAreaToLegendMargin + this.legendWidth + this.zLabelMargin + this.zLabelMaxWidth + this.rightMargin);
        } else {
            areaRightPixel = this.getImageWidth() - 1 - this.rightMargin;
        }
        area.setGraphArea(this.leftMargin, this.getImageHeight() - 1 - this.bottomMargin, areaRightPixel, this.topMargin);
        area.setGraphPadding(this.leftAreaMargin, this.bottomAreaMargin, this.rightAreaMargin, this.topAreaMargin);
        area.setLabelMargin(this.xLabelMargin, this.yLabelMargin);
        area.setRanges(this.getXPlotRange(), this.xValueScale, this.getYPlotRange(), this.yValueScale);
        area.prepareLabels(this.labelFont, this.labelColor);
        area.prepareGraphArea(true, this.referenceLineColor);
        area.drawGraphArea();
        if (this.drawLegend && this.zReferenceValues != null) {
            int[] zRefCoords = new int[this.zReferenceValues.size()];
            if (zRefCoords.length == 1) {
                zRefCoords[0] = area.areaTop;
            } else {
                for (int i = 0; i < zRefCoords.length; ++i) {
                    zRefCoords[i] = (int)this.scaledZ(this.zReferenceValues.getDouble(i), area.graphBottom, area.graphTop);
                }
            }
            this.zReferenceCoords = new ArrayInt(zRefCoords);
        }
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.optimizeColorScheme) {
            this.colorMapInstance = this.colorMap.createInstance(this.zPlotRange);
        } else if (this.colorMapInstance == null || !RangeUtil.equals(this.optimizedRange, this.zRange)) {
            this.colorMapInstance = this.colorMap.createInstance(this.zPlotRange);
            this.colorMapInstance = NumberColorMaps.optimize(this.colorMapInstance, this.zPlotRange);
            this.optimizedRange = this.zPlotRange;
        }
        double xStartGraph = this.xPlotCoordStart;
        double yEndGraph = area.graphBottom;
        double yHeightTotal = area.graphBottom - area.graphTop + 1;
        int startX = area.graphLeft;
        int startY = area.graphTop;
        int endX = area.graphRight;
        int endY = area.graphBottom;
        PointToDataMap xPointToDataMap = this.createXPointToDataMap(startX, endX, graphBuffer, data.getXBoundaries());
        PointToDataMap yPointToDataMap = this.createYPointToDataMap(startY, endY, graphBuffer, data.getYBoundaries());
        graphBuffer.drawDataImage(xPointToDataMap.startPoint, yPointToDataMap.startPoint, xPointToDataMap.pointToDataMap, yPointToDataMap.pointToDataMap, data, this.colorMapInstance);
        if (this.drawLegend && this.legendWidth > 0) {
            ListNumber dataList = ListNumbers.linearListFromRange((double)this.zPlotRange.getMinimum().doubleValue(), (double)this.zPlotRange.getMaximum().doubleValue(), (int)((int)yHeightTotal));
            Cell2DDataset legendData = Cell2DDatasets.linearRange(dataList, RangeUtil.range(0.0, 1.0), 1, RangeUtil.range(0.0, (int)yHeightTotal), (int)yHeightTotal);
            int xLegendStart = this.getImageWidth() - this.originalRightMargin - this.zLabelMaxWidth - this.zLabelMargin - this.legendWidth;
            this.drawRectanglesArray(this.g, legendData, xLegendStart, yEndGraph, this.legendWidth, yHeightTotal, 1.0, this.legendWidth, image);
            graphBuffer.drawLeftLabels(this.zReferenceLabels, this.zReferenceCoords, this.labelColor, this.labelFont, area.areaBottom, area.areaTop, this.getImageWidth() - this.originalRightMargin - 1);
        }
    }

    @Override
    public IntensityGraph2DRendererUpdate newUpdate() {
        return new IntensityGraph2DRendererUpdate();
    }

    PointToDataMap createXPointToDataMap(int leftPixel, int rightPixel, GraphBuffer buffer, ListNumber xBoundaries) {
        int minValuePixel = buffer.xValueToPixel(xBoundaries.getDouble(0));
        int maxValuePixel = buffer.xValueToPixel(xBoundaries.getDouble(xBoundaries.size() - 1));
        if (minValuePixel > rightPixel || maxValuePixel < leftPixel) {
            PointToDataMap result = new PointToDataMap();
            result.pointToDataMap = new int[0];
            result.startPoint = leftPixel;
            return result;
        }
        int startPixel = Math.max(minValuePixel, leftPixel);
        int endPixel = Math.min(maxValuePixel, rightPixel);
        int nPoints = endPixel - startPixel + 1;
        int[] pointToDataMap = new int[nPoints];
        int currentValueIndex = 0;
        int currentLeftBoundaryPixel = minValuePixel;
        int currentRightBoundaryPixel = buffer.xValueToPixel(xBoundaries.getDouble(1));
        for (int currentOffset = 0; currentOffset < pointToDataMap.length; ++currentOffset) {
            int currentPixel = startPixel + currentOffset;
            while ((currentRightBoundaryPixel < currentPixel || currentRightBoundaryPixel == currentPixel && currentLeftBoundaryPixel != currentPixel) && currentValueIndex < xBoundaries.size() - 2) {
                currentLeftBoundaryPixel = currentRightBoundaryPixel;
                currentRightBoundaryPixel = buffer.xValueToPixel(xBoundaries.getDouble(++currentValueIndex + 1));
            }
            pointToDataMap[currentOffset] = currentValueIndex;
        }
        PointToDataMap result = new PointToDataMap();
        result.pointToDataMap = pointToDataMap;
        result.startPoint = startPixel;
        return result;
    }

    PointToDataMap createYPointToDataMap(int topPixel, int bottomPixel, GraphBuffer buffer, ListNumber yBoundaries) {
        int minValuePixel = buffer.yValueToPixel(yBoundaries.getDouble(0));
        int maxValuePixel = buffer.yValueToPixel(yBoundaries.getDouble(yBoundaries.size() - 1));
        if (minValuePixel < topPixel || maxValuePixel > bottomPixel) {
            PointToDataMap result = new PointToDataMap();
            result.pointToDataMap = new int[0];
            result.startPoint = topPixel;
            return result;
        }
        int startPixel = Math.max(maxValuePixel, topPixel);
        int endPixel = Math.min(minValuePixel, bottomPixel);
        int nPoints = endPixel - startPixel + 1;
        int[] pointToDataMap = new int[nPoints];
        int currentValueIndex = 0;
        int currentBottomBoundaryPixel = minValuePixel;
        int currentTopBoundaryPixel = buffer.yValueToPixel(yBoundaries.getDouble(1));
        for (int currentOffset = 0; currentOffset < pointToDataMap.length; ++currentOffset) {
            int currentPixel = endPixel - currentOffset;
            while ((currentTopBoundaryPixel > currentPixel || currentTopBoundaryPixel == currentPixel && currentBottomBoundaryPixel != currentPixel) && currentValueIndex < yBoundaries.size() - 2) {
                currentBottomBoundaryPixel = currentTopBoundaryPixel;
                currentTopBoundaryPixel = buffer.yValueToPixel(yBoundaries.getDouble(++currentValueIndex + 1));
            }
            pointToDataMap[nPoints - currentOffset - 1] = currentValueIndex;
        }
        PointToDataMap result = new PointToDataMap();
        result.pointToDataMap = pointToDataMap;
        result.startPoint = startPixel;
        return result;
    }

    private void drawRectanglesArray(Graphics2D g, Cell2DDataset data, double xStartGraph, double yEndGraph, double xWidthTotal, double yHeightTotal, double cellHeight, double cellWidth, BufferedImage image) {
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        boolean hasAlphaChannel = image.getAlphaRaster() != null;
        double yPosition = yEndGraph - yHeightTotal;
        int yPositionInt = (int)(yEndGraph - yHeightTotal);
        for (int countY = 0; countY < data.getYCount(); ++countY) {
            double xPosition = xStartGraph;
            int xPositionInt = (int)xStartGraph;
            for (int countX = 0; countX < data.getXCount(); ++countX) {
                int rgb = this.colorMapInstance.colorFor(data.getValue(countX, data.getYCount() - 1 - countY));
                for (int w = 0; w < (int)cellWidth + 1; ++w) {
                    for (int h = 0; h < (int)cellHeight + 1; ++h) {
                        if (hasAlphaChannel) {
                            pixels[(yPositionInt + h) * this.getImageWidth() * 4 + 4 * xPositionInt + 0] = (byte)(rgb >> 24 & 0xFF);
                            pixels[(yPositionInt + h) * this.getImageWidth() * 4 + 4 * xPositionInt + 1] = (byte)(rgb & 0xFF);
                            pixels[(yPositionInt + h) * this.getImageWidth() * 4 + 4 * xPositionInt + 2] = (byte)(rgb >> 8 & 0xFF);
                            pixels[(yPositionInt + h) * this.getImageWidth() * 4 + 4 * xPositionInt + 3] = (byte)(rgb >> 16 & 0xFF);
                            continue;
                        }
                        pixels[(yPositionInt + h) * this.getImageWidth() * 3 + 3 * (xPositionInt + w) + 0] = (byte)(rgb & 0xFF);
                        pixels[(yPositionInt + h) * this.getImageWidth() * 3 + 3 * (xPositionInt + w) + 1] = (byte)(rgb >> 8 & 0xFF);
                        pixels[(yPositionInt + h) * this.getImageWidth() * 3 + 3 * (xPositionInt + w) + 2] = (byte)(rgb >> 16 & 0xFF);
                    }
                }
                xPositionInt = (int)(xPosition += cellWidth);
            }
            yPositionInt = (int)(yPosition += cellHeight);
        }
    }

    protected void calculateZRange(Range zDataRange, Range displayRange) {
        this.zPlotRange = this.zAxisRange.axisRange(zDataRange, displayRange);
    }

    protected void calculateZLabels() {
        ValueAxis zAxis;
        this.labelFontMetrics = this.g.getFontMetrics(this.labelFont);
        if (!this.zPlotRange.getMinimum().equals(this.zPlotRange.getMaximum())) {
            zAxis = this.zValueScale.references(this.zPlotRange, 2, Math.max(2, this.getImageHeight() / 60));
            this.zReferenceLabels = Arrays.asList(zAxis.getTickLabels());
            this.zReferenceValues = new ArrayDouble(zAxis.getTickValues());
        } else {
            zAxis = this.zValueScale.references(this.zPlotRange, 1, 1);
            this.zReferenceLabels = Arrays.asList(zAxis.getTickLabels());
            this.zReferenceValues = new ArrayDouble(new double[]{this.zPlotRange.getMinimum().doubleValue()});
        }
        int[] zLabelWidths = new int[this.zReferenceLabels.size()];
        this.zLabelMaxWidth = 0;
        for (int i = 0; i < zLabelWidths.length; ++i) {
            zLabelWidths[i] = this.labelFontMetrics.stringWidth(this.zReferenceLabels.get(i));
            this.zLabelMaxWidth = Math.max(this.zLabelMaxWidth, zLabelWidths[i]);
        }
    }

    protected final double scaledZ(double value, int bottomPixel, int topPixel) {
        return Math.ceil(this.zValueScale.scaleValue(value, this.zPlotRange.getMinimum().doubleValue(), this.zPlotRange.getMaximum().doubleValue(), bottomPixel, topPixel));
    }

    public boolean isDrawLegend() {
        return this.drawLegend;
    }

    public NumberColorMap getColorMap() {
        return this.colorMap;
    }

    private class PointToDataMap {
        public int[] pointToDataMap;
        public int startPoint;

        private PointToDataMap() {
        }
    }
}

