/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.NumberColorMaps;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.ReductionScheme;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.array.SortedListView;

public class LineGraph2DRenderer
extends Graph2DRenderer<LineGraph2DRendererUpdate> {
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOR, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    public static List<ReductionScheme> supportedReductionScheme = Arrays.asList(ReductionScheme.FIRST_MAX_MIN_LAST, ReductionScheme.NONE);
    private NumberColorMap valueColorScheme = NumberColorMaps.GRAY;
    private NumberColorMapInstance valueColorSchemeInstance;
    private Range datasetRange;
    private InterpolationScheme interpolation = InterpolationScheme.NEAREST_NEIGHBOR;
    private ReductionScheme reduction = ReductionScheme.FIRST_MAX_MIN_LAST;
    private Integer focusPixelX;
    private boolean highlightFocusValue = false;
    private int focusValueIndex = -1;
    private int currentIndex;
    private double currentScaledDiff;

    @Override
    public LineGraph2DRendererUpdate newUpdate() {
        return new LineGraph2DRendererUpdate();
    }

    public LineGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    public boolean isHighlightFocusValue() {
        return this.highlightFocusValue;
    }

    public int getFocusValueIndex() {
        return this.focusValueIndex;
    }

    public Integer getFocusPixelX() {
        return this.focusPixelX;
    }

    @Override
    public void update(LineGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getValueColorScheme() != null) {
            this.valueColorScheme = update.getValueColorScheme();
            this.valueColorSchemeInstance = this.valueColorScheme.createInstance(this.datasetRange);
        }
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
        if (update.getDataReduction() != null) {
            this.reduction = update.getDataReduction();
        }
        if (update.getFocusPixelX() != null) {
            this.focusPixelX = update.getFocusPixelX();
        }
        if (update.getHighlightFocusValue() != null) {
            this.highlightFocusValue = update.getHighlightFocusValue();
        }
    }

    public void draw(Graphics2D g, Point2DDataset data) {
        this.g = g;
        this.calculateRanges(data.getXStatistics(), data.getYStatistics());
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        SortedListView xValues = ListNumbers.sortedView((ListNumber)data.getXValues());
        SortedListView yValues = ListNumbers.sortedView((ListNumber)data.getYValues(), (ListInt)xValues.getIndexes());
        this.setClip(g);
        g.setColor(Color.BLACK);
        this.currentIndex = 0;
        this.currentScaledDiff = this.getImageWidth();
        this.drawValueExplicitLine((ListNumber)xValues, (ListNumber)yValues, this.interpolation, this.reduction);
        if (this.focusPixelX != null) {
            this.focusValueIndex = xValues.getIndexes().getInt(this.currentIndex);
            if (this.highlightFocusValue) {
                g.setColor(new Color(0, 0, 0, 128));
                int x = (int)this.scaledX(xValues.getDouble(this.currentIndex));
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g.drawLine(x, this.yAreaCoordStart, x, this.yAreaCoordEnd - 1);
            }
        } else {
            this.focusValueIndex = -1;
        }
    }

    public void draw(Graphics2D g, List<Point2DDataset> data) {
        this.g = g;
        for (Point2DDataset dataPiece : data) {
            super.calculateRanges(dataPiece.getXStatistics(), dataPiece.getYStatistics());
        }
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        Range datasetRangeCheck = RangeUtil.range(0.0, data.size());
        if (this.valueColorSchemeInstance == null || this.datasetRange == null || this.datasetRange != datasetRangeCheck) {
            this.datasetRange = datasetRangeCheck;
            this.valueColorSchemeInstance = this.valueColorScheme.createInstance(this.datasetRange);
        }
        for (int datasetNumber = 0; datasetNumber < data.size(); ++datasetNumber) {
            SortedListView xValues = ListNumbers.sortedView((ListNumber)data.get(datasetNumber).getXValues());
            SortedListView yValues = ListNumbers.sortedView((ListNumber)data.get(datasetNumber).getYValues(), (ListInt)xValues.getIndexes());
            this.setClip(g);
            g.setColor(new Color(this.valueColorSchemeInstance.colorFor(datasetNumber)));
            this.drawValueExplicitLine((ListNumber)xValues, (ListNumber)yValues, this.interpolation, this.reduction);
        }
    }

    @Override
    protected void processScaledValue(int index, double valueX, double valueY, double scaledX, double scaledY) {
        double scaledDiff;
        if (this.focusPixelX != null && (scaledDiff = Math.abs(scaledX - (double)this.focusPixelX.intValue())) < this.currentScaledDiff) {
            this.currentIndex = index;
            this.currentScaledDiff = scaledDiff;
        }
    }
}

