/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

public class MathUtil {
    public static int orderOf(double value) {
        return (int)Math.floor(Math.log10(value));
    }

    public static double normalize(double value, double min, double max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("value not in range");
        }
        return (value - min) / (max - min);
    }

    public static double scale(double value, double min, double max, double newWidth) {
        return (value - min) * newWidth / (max - min);
    }
}

