/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.Range;

class NumberColorMapInstanceOptimized
implements NumberColorMapInstance {
    private int arrayLength = 1000;
    private int[] colors = new int[this.arrayLength];
    private int nanColor;
    private Range range;
    private double max;
    private double min;
    private double total;
    private final String name;

    NumberColorMapInstanceOptimized(NumberColorMapInstance instance, Range range) {
        this.min = range.getMinimum().doubleValue();
        this.max = range.getMaximum().doubleValue();
        this.total = this.max - this.min;
        for (int i = 0; i < this.arrayLength; ++i) {
            this.colors[i] = i == this.arrayLength - 1 ? instance.colorFor(this.max) : instance.colorFor(this.min + (double)i * (this.total / (double)(this.arrayLength - 1)));
        }
        this.range = range;
        this.name = instance.toString() + " opt(" + this.arrayLength + ")";
    }

    NumberColorMapInstanceOptimized(NumberColorMapInstance instance, Range oldRange, Range newRange) {
        double oldMin = oldRange.getMinimum().doubleValue();
        double oldMax = oldRange.getMaximum().doubleValue();
        double oldTotal = oldMax - oldMin;
        for (int i = 0; i < this.arrayLength; ++i) {
            this.colors[i] = i == this.arrayLength - 1 ? instance.colorFor(oldMax) : instance.colorFor(oldMin + (double)i * (oldTotal / (double)(this.arrayLength - 1)));
        }
        this.min = newRange.getMinimum().doubleValue();
        this.max = newRange.getMaximum().doubleValue();
        this.total = this.max - this.min;
        this.range = newRange;
        this.name = instance.toString() + " opt2(" + this.arrayLength + ")";
    }

    @Override
    public int colorFor(double value) {
        int index = (int)((value - this.min) / this.total * (double)(this.arrayLength - 1));
        if (index < 0) {
            index = 0;
        } else if (index >= this.colors.length) {
            index = this.colors.length - 1;
        }
        return this.colors[index];
    }

    public String toString() {
        return this.name;
    }
}

