/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.ScatterGraph2DRendererUpdate;
import org.epics.util.array.ListNumber;

public class ScatterGraph2DRenderer
extends Graph2DRenderer<ScatterGraph2DRendererUpdate> {
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NONE, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    private InterpolationScheme interpolation = InterpolationScheme.NONE;

    public ScatterGraph2DRenderer(int width, int height) {
        super(width, height);
        this.topAreaMargin = 2;
        this.bottomAreaMargin = 2;
        this.leftAreaMargin = 2;
        this.rightAreaMargin = 2;
    }

    @Override
    public ScatterGraph2DRendererUpdate newUpdate() {
        return new ScatterGraph2DRendererUpdate();
    }

    @Override
    public void update(ScatterGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
    }

    public void draw(Graphics2D g, Point2DDataset data) {
        this.calculateRanges(data.getXStatistics(), data.getYStatistics());
        this.g = g;
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawBackground();
        this.drawGraphArea();
        ListNumber xValues = data.getXValues();
        ListNumber yValues = data.getYValues();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.setClip(g);
        g.setColor(Color.BLACK);
        for (int i = 0; i < xValues.size(); ++i) {
            this.drawValue(g, xValues.getDouble(i), yValues.getDouble(i));
        }
        if (this.interpolation != InterpolationScheme.NONE) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            this.drawValueLine(data.getXValues(), data.getYValues(), this.interpolation);
        }
    }

    private void drawValue(Graphics2D g, double x, double y) {
        g.draw(this.createShape((int)this.scaledX(x), (int)this.scaledY(y)));
    }

    private Shape createShape(double x, double y) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(x - 2.0, y);
        path.lineTo(x + 2.0, y);
        path.moveTo(x, y - 2.0);
        path.lineTo(x, y + 2.0);
        return path;
    }
}

