/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRangeInstance;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.FontUtil;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.TemporalGraph2DRendererUpdate;
import org.epics.graphene.TimeAxis;
import org.epics.graphene.TimeAxisRange;
import org.epics.graphene.TimeAxisRanges;
import org.epics.graphene.TimeScale;
import org.epics.graphene.TimeScales;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;

public abstract class TemporalGraph2DRenderer<T extends TemporalGraph2DRendererUpdate> {
    protected double xPlotValueStart;
    protected double yPlotValueStart;
    protected double xPlotValueEnd;
    protected double yPlotValueEnd;
    protected double yPlotCoordHeight;
    protected double xPlotCoordWidth;
    protected double xPlotCoordStart;
    protected double yPlotCoordStart;
    protected double yPlotCoordEnd;
    protected double xPlotCoordEnd;
    protected int xAreaStart;
    protected int yAreaStart;
    protected int yAreaEnd;
    protected int xAreaEnd;
    protected int xRow2LabelMargin = 3;
    protected Graphics2D g;
    private int imageWidth;
    private int imageHeight;
    private TimeAxisRange timeAxisRange = TimeAxisRanges.relative();
    private AxisRangeInstance axisRange = AxisRanges.integrated().createInstance();
    private TimeScale timeScale = TimeScales.linearAbsoluteScale();
    private ValueScale valueScale = ValueScales.linearScale();
    protected Color backgroundColor = Color.WHITE;
    protected Color labelColor = Color.BLACK;
    protected Color referenceLineColor = new Color(240, 240, 240);
    protected Font labelFont = FontUtil.getLiberationSansRegular();
    protected int bottomMargin = 2;
    protected int topMargin = 2;
    protected int leftMargin = 2;
    protected int rightMargin = 2;
    protected int bottomAreaMargin = 0;
    protected int topAreaMargin = 0;
    protected int leftAreaMargin = 0;
    protected int rightAreaMargin = 0;
    protected int xLabelMargin = 3;
    protected int yLabelMargin = 3;
    private Range aggregatedValueRange;
    private TimeInterval aggregatedTimeInterval;
    private Range plotValueRange;
    private TimeInterval plotTimeInterval;
    protected FontMetrics labelFontMetrics;
    protected ListDouble xReferenceCoords;
    protected ListDouble valueReferences;
    protected List<String> valueReferenceLabels;
    protected ListDouble yReferenceCoords;
    protected List<Timestamp> timeReferences;
    protected ListDouble normalizedTimeReferences;
    protected List<String> timeReferenceLabels;
    private int xLabelMaxHeight;
    private int yLabelMaxWidth;
    private static final int MIN = 0;
    private static final int MAX = 1;

    public TemporalGraph2DRenderer(int graphWidth, int graphHeight) {
        this.imageWidth = graphWidth;
        this.imageHeight = graphHeight;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public AxisRange getAxisRange() {
        return this.axisRange.getAxisRange();
    }

    public TimeAxisRange getTimeAxisRange() {
        return this.timeAxisRange;
    }

    public Range getAggregatedRange() {
        return this.aggregatedValueRange;
    }

    public TimeInterval getAggregatedTimeInterval() {
        return this.aggregatedTimeInterval;
    }

    public Range getPlotRange() {
        return this.plotValueRange;
    }

    public TimeInterval getPlotTimeInterval() {
        return this.plotTimeInterval;
    }

    public void update(T update) {
        if (((TemporalGraph2DRendererUpdate)update).getImageHeight() != null) {
            this.imageHeight = ((TemporalGraph2DRendererUpdate)update).getImageHeight();
        }
        if (((TemporalGraph2DRendererUpdate)update).getImageWidth() != null) {
            this.imageWidth = ((TemporalGraph2DRendererUpdate)update).getImageWidth();
        }
        if (((TemporalGraph2DRendererUpdate)update).getAxisRange() != null) {
            this.axisRange = ((TemporalGraph2DRendererUpdate)update).getAxisRange().createInstance();
        }
        if (((TemporalGraph2DRendererUpdate)update).getTimeAxisRange() != null) {
            this.timeAxisRange = ((TemporalGraph2DRendererUpdate)update).getTimeAxisRange();
        }
        if (((TemporalGraph2DRendererUpdate)update).getValueScale() != null) {
            this.valueScale = ((TemporalGraph2DRendererUpdate)update).getValueScale();
        }
        if (((TemporalGraph2DRendererUpdate)update).getTimeScale() != null) {
            this.timeScale = ((TemporalGraph2DRendererUpdate)update).getTimeScale();
        }
    }

    static Range aggregateRange(Range dataRange, Range aggregatedRange) {
        if (aggregatedRange == null) {
            return dataRange;
        }
        return RangeUtil.sum(dataRange, aggregatedRange);
    }

    static TimeInterval aggregateTimeInterval(TimeInterval dataTimeInterval, TimeInterval aggregatedTimeInterval) {
        if (aggregatedTimeInterval == null) {
            return dataTimeInterval;
        }
        if (aggregatedTimeInterval.contains(dataTimeInterval.getEnd()) && aggregatedTimeInterval.contains(dataTimeInterval.getStart())) {
            return aggregatedTimeInterval;
        }
        if (dataTimeInterval.contains(aggregatedTimeInterval.getEnd()) && dataTimeInterval.contains(aggregatedTimeInterval.getStart())) {
            return dataTimeInterval;
        }
        Timestamp start = dataTimeInterval.getStart().compareTo(aggregatedTimeInterval.getStart()) > 0 ? aggregatedTimeInterval.getStart() : dataTimeInterval.getStart();
        Timestamp end = dataTimeInterval.getEnd().compareTo(aggregatedTimeInterval.getEnd()) < 0 ? aggregatedTimeInterval.getEnd() : dataTimeInterval.getEnd();
        return TimeInterval.between((Timestamp)start, (Timestamp)end);
    }

    public abstract T newUpdate();

    protected void calculateRanges(Range valueRange, TimeInterval timeInterval) {
        this.aggregatedValueRange = TemporalGraph2DRenderer.aggregateRange(valueRange, this.aggregatedValueRange);
        this.aggregatedTimeInterval = TemporalGraph2DRenderer.aggregateTimeInterval(timeInterval, this.aggregatedTimeInterval);
        this.plotValueRange = this.axisRange.axisRange(valueRange, valueRange);
        this.plotTimeInterval = this.timeAxisRange.axisRange(timeInterval, this.aggregatedTimeInterval);
    }

    protected void drawHorizontalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble yTicks = this.yReferenceCoords;
        for (int i = 0; i < yTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(this.xAreaStart, yTicks.getDouble(i), this.xAreaEnd, yTicks.getDouble(i));
            this.g.draw(line);
        }
    }

    protected void drawVerticalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble xTicks = this.xReferenceCoords;
        for (int i = 0; i < xTicks.size(); ++i) {
            Line2D.Double line = new Line2D.Double(xTicks.getDouble(i), this.yAreaStart, xTicks.getDouble(i), this.yAreaEnd);
            this.g.draw(line);
        }
    }

    protected void calculateGraphArea() {
        TimeAxis timeAxis = this.timeScale.references(this.plotTimeInterval, 2, Math.max(2, this.getImageWidth() / 100));
        ValueAxis valueAxis = this.valueScale.references(this.plotValueRange, 2, Math.max(2, this.getImageHeight() / 60));
        this.timeReferenceLabels = timeAxis.getTickLabels();
        this.valueReferenceLabels = Arrays.asList(valueAxis.getTickLabels());
        this.timeReferences = timeAxis.getTimestamps();
        this.normalizedTimeReferences = timeAxis.getNormalizedValues();
        this.valueReferences = new ArrayDouble(valueAxis.getTickValues());
        this.labelFontMetrics = this.g.getFontMetrics(this.labelFont);
        this.xLabelMaxHeight = this.labelFontMetrics.getHeight() - this.labelFontMetrics.getLeading();
        int areaFromBottom = this.bottomMargin + this.xLabelMaxHeight * 2 + this.xLabelMargin + 3;
        int[] yLabelWidths = new int[this.valueReferenceLabels.size()];
        this.yLabelMaxWidth = 0;
        for (int i = 0; i < yLabelWidths.length; ++i) {
            yLabelWidths[i] = this.labelFontMetrics.stringWidth(this.valueReferenceLabels.get(i));
            this.yLabelMaxWidth = Math.max(this.yLabelMaxWidth, yLabelWidths[i]);
        }
        int areaFromLeft = this.leftMargin + this.yLabelMaxWidth + this.yLabelMargin;
        this.xPlotValueStart = 0.0;
        this.yPlotValueStart = this.getPlotRange().getMinimum().doubleValue();
        this.xPlotValueEnd = 1.0;
        this.yPlotValueEnd = this.getPlotRange().getMaximum().doubleValue();
        this.xAreaStart = areaFromLeft;
        this.yAreaStart = this.topMargin;
        this.xAreaEnd = this.getImageWidth() - this.rightMargin - 1;
        this.yAreaEnd = this.getImageHeight() - areaFromBottom - 1;
        this.xPlotCoordStart = (double)(this.xAreaStart + this.topAreaMargin) + 0.5;
        this.yPlotCoordStart = (double)(this.yAreaStart + this.leftAreaMargin) + 0.5;
        this.xPlotCoordEnd = (double)(this.xAreaEnd - this.bottomAreaMargin) + 0.5;
        this.yPlotCoordEnd = (double)(this.yAreaEnd - this.rightAreaMargin) + 0.5;
        this.xPlotCoordWidth = this.xPlotCoordEnd - this.xPlotCoordStart;
        this.yPlotCoordHeight = this.yPlotCoordEnd - this.yPlotCoordStart;
        double[] xRefCoords = new double[this.normalizedTimeReferences.size()];
        for (int i = 0; i < xRefCoords.length; ++i) {
            xRefCoords[i] = this.scaledX(this.normalizedTimeReferences.getDouble(i));
        }
        this.xReferenceCoords = new ArrayDouble(xRefCoords);
        double[] yRefCoords = new double[this.valueReferences.size()];
        for (int i = 0; i < yRefCoords.length; ++i) {
            yRefCoords[i] = this.scaledY(this.valueReferences.getDouble(i));
        }
        this.yReferenceCoords = new ArrayDouble(yRefCoords);
    }

    protected void drawBackground() {
        this.g.setColor(this.backgroundColor);
        this.g.fillRect(0, 0, this.getImageWidth(), this.getImageHeight());
    }

    protected void drawGraphArea() {
        this.drawBackground();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawVerticalReferenceLines();
        this.drawHorizontalReferenceLines();
        this.drawYLabels();
        this.drawXLabels();
    }

    protected void drawValueLine(ListNumber xValues, ListNumber yValues, InterpolationScheme interpolation) {
        Path2D.Double path;
        int dataCount = xValues.size();
        double[] scaledX = new double[dataCount];
        double[] scaledY = new double[dataCount];
        for (int i = 0; i < scaledY.length; ++i) {
            scaledX[i] = this.scaledX(xValues.getDouble(i));
            scaledY[i] = this.scaledY(yValues.getDouble(i));
        }
        switch (interpolation) {
            default: {
                throw new IllegalArgumentException("Interpolation " + (Object)((Object)interpolation) + " not supported");
            }
            case NEAREST_NEIGHBOR: {
                path = TemporalGraph2DRenderer.nearestNeighbour(scaledX, scaledY);
                break;
            }
            case PREVIOUS_VALUE: {
                path = TemporalGraph2DRenderer.previousValue(scaledX, scaledY);
                break;
            }
            case LINEAR: {
                path = TemporalGraph2DRenderer.linearInterpolation(scaledX, scaledY);
                break;
            }
            case CUBIC: {
                path = TemporalGraph2DRenderer.cubicInterpolation(scaledX, scaledY);
            }
        }
        this.g.draw(path);
    }

    private static Path2D.Double nearestNeighbour(double[] scaledX, double[] scaledY) {
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[0], scaledY[0]);
        for (int i = 1; i < scaledY.length; ++i) {
            double halfX = scaledX[i - 1] + (scaledX[i] - scaledX[i - 1]) / 2.0;
            if (!Double.isNaN(scaledY[i - 1])) {
                line.lineTo(halfX, scaledY[i - 1]);
                if (Double.isNaN(scaledY[i])) continue;
                line.lineTo(halfX, scaledY[i]);
                continue;
            }
            line.moveTo(halfX, scaledY[i]);
        }
        line.lineTo(scaledX[scaledX.length - 1], scaledY[scaledY.length - 1]);
        return line;
    }

    private static Path2D.Double previousValue(double[] scaledX, double[] scaledY) {
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[0], scaledY[0]);
        for (int i = 1; i < scaledY.length; ++i) {
            line.lineTo(scaledX[i], scaledY[i - 1]);
            line.lineTo(scaledX[i], scaledY[i]);
        }
        return line;
    }

    private static Path2D.Double linearInterpolation(double[] scaledX, double[] scaledY) {
        Path2D.Double line = new Path2D.Double();
        for (int i = 0; i < scaledX.length; ++i) {
            if (Double.isNaN(scaledY[i])) continue;
            if (i != 0 && !Double.isNaN(scaledY[i - 1])) {
                line.lineTo(scaledX[i], scaledY[i]);
                continue;
            }
            if (i != scaledX.length - 1 && !Double.isNaN(scaledY[i + 1])) {
                line.moveTo(scaledX[i], scaledY[i]);
                continue;
            }
            line.moveTo(scaledX[i] - 1.0, scaledY[i]);
            line.lineTo(scaledX[i] + 1.0, scaledY[i]);
        }
        return line;
    }

    private static Path2D.Double cubicInterpolation(double[] scaledX, double[] scaledY) {
        Path2D.Double path = new Path2D.Double();
        for (int i = 0; i < scaledX.length; ++i) {
            if (Double.isNaN(scaledY[i])) continue;
            if (i > 0 && !Double.isNaN(scaledY[i - 1])) {
                double by2;
                double bx2;
                double by1;
                double bx1;
                double bdy3;
                double bdy0;
                double by3;
                double bx3;
                double by0;
                double bx0;
                double x1;
                double y1;
                double x3;
                double y3;
                double x0;
                double y0;
                double x2;
                double y2;
                if (i > 1 && !Double.isNaN(scaledY[i - 2])) {
                    if (i != scaledX.length - 1 && !Double.isNaN(scaledY[i + 1])) {
                        y2 = scaledY[i];
                        x2 = scaledX[i];
                        y0 = scaledY[i - 2];
                        x0 = scaledX[i - 2];
                        y3 = scaledY[i + 1];
                        x3 = scaledX[i + 1];
                        y1 = scaledY[i - 1];
                        bx0 = x1 = scaledX[i - 1];
                        by0 = y1;
                        bx3 = x2;
                        by3 = y2;
                        bdy0 = (y2 - y0) / (x2 - x0);
                        bdy3 = (y3 - y1) / (x3 - x1);
                        bx1 = bx0 + (x2 - x0) / 6.0;
                        by1 = (bx1 - bx0) * bdy0 + by0;
                        bx2 = bx3 - (x3 - x1) / 6.0;
                        by2 = (bx2 - bx3) * bdy3 + by3;
                        path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                        continue;
                    }
                    y2 = scaledY[i];
                    x2 = scaledX[i];
                    y1 = scaledY[i - 1];
                    x1 = scaledX[i - 1];
                    y0 = scaledY[i - 2];
                    x0 = scaledX[i - 2];
                    y3 = y2 + (y2 - y1) / 2.0;
                    x3 = x2 + (x2 - x1) / 2.0;
                    bx0 = x1;
                    by0 = y1;
                    bx3 = x2;
                    by3 = y2;
                    bdy0 = (y2 - y0) / (x2 - x0);
                    bdy3 = (y3 - y1) / (x3 - x1);
                    bx1 = bx0 + (x2 - x0) / 6.0;
                    by1 = (bx1 - bx0) * bdy0 + by0;
                    bx2 = bx3 - (x3 - x1) / 6.0;
                    by2 = (bx2 - bx3) * bdy3 + by3;
                    path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                    continue;
                }
                if (i != scaledX.length - 1 && !Double.isNaN(scaledY[i + 1])) {
                    path.moveTo(scaledX[i - 1], scaledY[i - 1]);
                    y2 = scaledY[i];
                    x2 = scaledX[i];
                    y1 = scaledY[i - 1];
                    x1 = scaledX[i - 1];
                    y0 = y1 - (y2 - y1) / 2.0;
                    x0 = x1 - (x2 - x1) / 2.0;
                    y3 = scaledY[i + 1];
                    x3 = scaledX[i + 1];
                    bx0 = x1;
                    by0 = y1;
                    bx3 = x2;
                    by3 = y2;
                    bdy0 = (y2 - y0) / (x2 - x0);
                    bdy3 = (y3 - y1) / (x3 - x1);
                    bx1 = bx0 + (x2 - x0) / 6.0;
                    by1 = (bx1 - bx0) * bdy0 + by0;
                    bx2 = bx3 - (x3 - x1) / 6.0;
                    by2 = (bx2 - bx3) * bdy3 + by3;
                    path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                    continue;
                }
                path.lineTo(scaledX[i], scaledY[i]);
                continue;
            }
            if (i != scaledX.length - 1 && !Double.isNaN(scaledY[i + 1])) {
                path.moveTo(scaledX[i], scaledY[i]);
                continue;
            }
            path.moveTo(scaledX[i] - 1.0, scaledY[i]);
            path.lineTo(scaledX[i] + 1.0, scaledY[i]);
        }
        return path;
    }

    private static void drawHorizontalReferencesLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    private static void drawVerticalReferenceLabel(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    protected final double scaledX(double value) {
        return this.timeScale.scaleNormalizedTime(value, this.xPlotCoordStart, this.xPlotCoordEnd);
    }

    protected final double scaledY(double value) {
        return this.valueScale.scaleValue(value, this.yPlotValueStart, this.yPlotValueEnd, this.yPlotCoordEnd, this.yPlotCoordStart);
    }

    protected void setClip(Graphics2D g) {
        g.setClip(this.xAreaStart, this.yAreaStart, this.xAreaEnd - this.xAreaStart + 1, this.yAreaEnd - this.yAreaStart + 1);
    }

    protected void drawYLabels() {
        ListDouble yTicks = this.yReferenceCoords;
        if (this.valueReferenceLabels != null && !this.valueReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.yAreaStart, this.yAreaEnd};
            int xRightLabel = this.xAreaStart - this.yLabelMargin - 1;
            TemporalGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.valueReferenceLabels.get(0), (int)Math.floor(yTicks.getDouble(0)), drawRange, xRightLabel, true, false);
            TemporalGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.valueReferenceLabels.get(this.valueReferenceLabels.size() - 1), (int)Math.floor(yTicks.getDouble(this.valueReferenceLabels.size() - 1)), drawRange, xRightLabel, false, false);
            for (int i = 1; i < this.valueReferenceLabels.size() - 1; ++i) {
                TemporalGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.valueReferenceLabels.get(i), (int)Math.floor(yTicks.getDouble(i)), drawRange, xRightLabel, true, false);
            }
        }
    }

    protected void drawXLabels() {
        ListDouble xTicks = this.xReferenceCoords;
        if (this.timeReferenceLabels != null && !this.timeReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.xAreaStart, this.xAreaEnd};
            int yTop = this.yAreaEnd + this.xLabelMargin + 1;
            String firstHalf = this.timeReferenceLabels.get(0).substring(0, this.timeReferenceLabels.get(0).indexOf(" "));
            String secondHalf = this.timeReferenceLabels.get(0).substring(this.timeReferenceLabels.get(0).indexOf(" ") + 1);
            TemporalGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, secondHalf, (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop, true, false);
            drawRange[0] = this.xAreaStart;
            TemporalGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, firstHalf, (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop + this.xLabelMaxHeight + this.xRow2LabelMargin, true, false);
            TemporalGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.timeReferenceLabels.get(this.timeReferenceLabels.size() - 1), (int)Math.floor(xTicks.getDouble(this.timeReferenceLabels.size() - 1)), drawRange, yTop, false, false);
            for (int i = 1; i < this.timeReferenceLabels.size() - 1; ++i) {
                TemporalGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.timeReferenceLabels.get(i), (int)Math.floor(xTicks.getDouble(i)), drawRange, yTop, true, false);
            }
        }
    }
}

