/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.epics.util.array.ListDouble;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;

public class TimeAxis {
    private TimeInterval timeInterval;
    private List<Timestamp> timeStamps;
    private ListDouble normalizedValues;
    private List<String> tickLabels;
    private static final DecimalFormat defaultFormat = new DecimalFormat("0.###");
    private static final DecimalFormat decimal0 = new DecimalFormat("0");
    private static final DecimalFormat decimal1 = new DecimalFormat("0.0");
    private static final DecimalFormat decimal2 = new DecimalFormat("0.00");
    private static final Map<Integer, DecimalFormat> formats = new ConcurrentHashMap<Integer, DecimalFormat>();

    public TimeAxis(TimeInterval timeInterval, List<Timestamp> timeStamps, ListDouble normalizedValues, List<String> tickLabels) {
        this.timeInterval = timeInterval;
        this.timeStamps = timeStamps;
        this.normalizedValues = normalizedValues;
        this.tickLabels = tickLabels;
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public List<Timestamp> getTimestamps() {
        return this.timeStamps;
    }

    public ListDouble getNormalizedValues() {
        return this.normalizedValues;
    }

    public List<String> getTickLabels() {
        return this.tickLabels;
    }

    public static TimeAxis createAutoAxis(double minValue, double maxValue, int maxTicks) {
        return TimeAxis.createAutoAxis(minValue, maxValue, maxTicks, Double.MIN_VALUE);
    }

    static DecimalFormat formatWithFixedSignificantDigits(int significantDigits) {
        DecimalFormat result = formats.get(significantDigits);
        if (result == null) {
            StringBuilder pattern = new StringBuilder("0");
            for (int i = 0; i < significantDigits; ++i) {
                if (i == 0) {
                    pattern.append(".");
                }
                pattern.append("0");
            }
            result = new DecimalFormat(pattern.toString());
            formats.put(significantDigits, result);
        }
        return result;
    }

    public static TimeAxis createAutoAxis(double minValue, double maxValue, int maxTicks, double minIncrement) {
        double increment = TimeAxis.incrementForRange(minValue, maxValue, maxTicks, minIncrement);
        double[] ticks = TimeAxis.createTicks(minValue, maxValue, increment);
        if (ticks.length < 2) {
            ticks = TimeAxis.createSmallerTicks(minValue, maxValue, increment);
        }
        int rangeOrder = (int)TimeAxis.orderOfMagnitude(minValue, maxValue);
        int incrementOrder = (int)TimeAxis.orderOfMagnitude(increment);
        int nDigits = rangeOrder - incrementOrder;
        DecimalFormat format = defaultFormat;
        double normalization = 1.0;
        String exponent = null;
        if (rangeOrder >= -3 && rangeOrder <= 3) {
            format = incrementOrder < 0 ? TimeAxis.formatWithFixedSignificantDigits(-incrementOrder) : TimeAxis.formatWithFixedSignificantDigits(0);
        } else if (rangeOrder > 3) {
            format = TimeAxis.formatWithFixedSignificantDigits(nDigits);
            normalization = Math.pow(10.0, rangeOrder);
            exponent = Integer.toString(rangeOrder);
        } else if (rangeOrder < -3) {
            format = TimeAxis.formatWithFixedSignificantDigits(nDigits);
            normalization = Math.pow(10.0, rangeOrder);
            exponent = Integer.toString(rangeOrder);
        }
        String[] labels = new String[ticks.length];
        for (int i = 0; i < ticks.length; ++i) {
            double value = ticks[i];
            labels[i] = TimeAxis.format(value, format, exponent, normalization);
        }
        return null;
    }

    static String format(double number, DecimalFormat format, String exponent, double normalization) {
        if (exponent != null) {
            return format.format(number / normalization) + "e" + exponent;
        }
        return format.format(number / normalization);
    }

    static double orderOfMagnitude(double value) {
        return Math.floor(Math.log10(value));
    }

    static double orderOfMagnitude(double min, double max) {
        return TimeAxis.orderOfMagnitude(Math.max(Math.abs(max), Math.abs(min)));
    }

    static double incrementForRange(double min, double max, int maxTick, double minIncrement) {
        int order;
        BigDecimal magnitude;
        double range = max - min;
        double increment = Math.max(range / (double)maxTick, minIncrement);
        double normalizedIncrement = increment / (magnitude = BigDecimal.ONE.scaleByPowerOfTen(order = (int)TimeAxis.orderOfMagnitude(increment))).doubleValue();
        if (normalizedIncrement <= 1.0) {
            return magnitude.doubleValue();
        }
        if (normalizedIncrement <= 2.0) {
            return magnitude.multiply(BigDecimal.valueOf(2L)).doubleValue();
        }
        if (normalizedIncrement <= 5.0) {
            return magnitude.multiply(BigDecimal.valueOf(5L)).doubleValue();
        }
        return magnitude.multiply(BigDecimal.valueOf(10L)).doubleValue();
    }

    private static double[] createSmallerTicks(double minValue, double maxValue, double increment) {
        int order = (int)TimeAxis.orderOfMagnitude(increment);
        BigDecimal magnitude = BigDecimal.ONE.scaleByPowerOfTen(order);
        double normalizedIncrement = increment / magnitude.doubleValue();
        double smallerIncrement = normalizedIncrement < 1.1 ? BigDecimal.ONE.scaleByPowerOfTen(order - 1).multiply(BigDecimal.valueOf(5L)).doubleValue() : (normalizedIncrement < 2.1 ? magnitude.doubleValue() : (normalizedIncrement < 5.1 ? magnitude.multiply(BigDecimal.valueOf(2L)).doubleValue() : magnitude.multiply(BigDecimal.valueOf(5L)).doubleValue()));
        return TimeAxis.createTicks(minValue, maxValue, smallerIncrement);
    }

    static int countTicks(double min, double max, double increment) {
        int start = (int)Math.ceil(min / increment);
        int end = (int)Math.floor(max / increment);
        return end - start + 1;
    }

    static double[] createTicks(double min, double max, double increment) {
        long start = (long)Math.ceil(min / increment);
        long end = (long)Math.floor(max / increment);
        double[] ticks = new double[(int)(end - start + 1L)];
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = (double)((long)i + start) * increment;
        }
        return ticks;
    }
}

