/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.util.Objects;
import org.epics.graphene.AxisRange;
import org.epics.graphene.AxisRangeInstance;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;

public class AxisRanges {
    private static Data DATA = new Data();
    private static final Auto AUTO = new Auto(0.8);
    private static final Display DISPLAY = new Display();

    private AxisRanges() {
    }

    public static AxisRange fixed(double min, double max) {
        Range fixedRange = Ranges.range((double)min, (double)max);
        return new Fixed(fixedRange);
    }

    public static AxisRange data() {
        return DATA;
    }

    public static AxisRange auto() {
        return AUTO;
    }

    public static AxisRange auto(double minUsage) {
        return new Auto(minUsage);
    }

    public static AxisRange display() {
        return DISPLAY;
    }

    public static class Display
    implements AxisRange {
        private final AxisRange axisRange = this;

        private Display() {
        }

        @Override
        public AxisRangeInstance createInstance() {
            return new AxisRangeInstance(){
                private Range previousDataRange;

                @Override
                public Range axisRange(Range dataRange, Range displayRange) {
                    if (Ranges.isValid((Range)displayRange)) {
                        return displayRange;
                    }
                    if (this.previousDataRange == null) {
                        this.previousDataRange = dataRange;
                        return this.previousDataRange;
                    }
                    return this.previousDataRange;
                }

                @Override
                public AxisRange getAxisRange() {
                    return Display.this.axisRange;
                }
            };
        }

        public String toString() {
            return "display";
        }
    }

    public static class Auto
    implements AxisRange {
        private final AxisRange axisRange = this;
        private final double minUsage;

        private Auto(double minUsage) {
            this.minUsage = minUsage;
        }

        @Override
        public AxisRangeInstance createInstance() {
            return new AxisRangeInstance(){
                private Range aggregatedRange;

                @Override
                public Range axisRange(Range dataRange, Range displayRange) {
                    this.aggregatedRange = Ranges.aggregateRange((Range)dataRange, (Range)this.aggregatedRange);
                    if (Ranges.overlap((Range)this.aggregatedRange, (Range)dataRange) < Auto.this.minUsage) {
                        this.aggregatedRange = dataRange;
                    }
                    return this.aggregatedRange;
                }

                @Override
                public AxisRange getAxisRange() {
                    return Auto.this.axisRange;
                }
            };
        }

        public String toString() {
            return "auto(" + (int)(this.minUsage * 100.0) + "%)";
        }

        public double getMinUsage() {
            return this.minUsage;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Auto) {
                return this.getMinUsage() == ((Auto)obj).getMinUsage();
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.getMinUsage());
            return hash;
        }
    }

    public static class Data
    implements AxisRange {
        private final AxisRange axisRange = this;

        private Data() {
        }

        @Override
        public AxisRangeInstance createInstance() {
            return new AxisRangeInstance(){

                @Override
                public Range axisRange(Range dataRange, Range displayRange) {
                    return dataRange;
                }

                @Override
                public AxisRange getAxisRange() {
                    return Data.this.axisRange;
                }
            };
        }

        public String toString() {
            return "data";
        }
    }

    public static class Fixed
    implements AxisRange {
        private final AxisRange axisRange = this;
        private final Range absoluteRange;

        private Fixed(Range absoluteRange) {
            this.absoluteRange = absoluteRange;
        }

        @Override
        public AxisRangeInstance createInstance() {
            return new AxisRangeInstance(){

                @Override
                public Range axisRange(Range dataRange, Range displayRange) {
                    return Fixed.this.absoluteRange;
                }

                @Override
                public AxisRange getAxisRange() {
                    return Fixed.this.axisRange;
                }
            };
        }

        public String toString() {
            return "fixed(" + this.absoluteRange.getMinimum() + ", " + this.absoluteRange.getMaximum() + ")";
        }

        public Range getFixedRange() {
            return this.absoluteRange;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Fixed) {
                return Ranges.equals((Range)this.getFixedRange(), (Range)((Fixed)obj).getFixedRange());
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Objects.hashCode(this.absoluteRange);
            return hash;
        }
    }
}

