/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.epics.graphene.AxisRangeInstance;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.BubbleGraph2DRendererUpdate;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.LabelColorScheme;
import org.epics.graphene.LabelColorSchemes;
import org.epics.graphene.MathUtil;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;

public class BubbleGraph2DRenderer
extends Graph2DRenderer<BubbleGraph2DRendererUpdate> {
    private Range zAggregatedRange;
    private AxisRangeInstance zAxisRange = AxisRanges.display().createInstance();
    private Range zPlotRange;
    private Integer focusPixelX;
    private Integer focusPixelY;
    private boolean highlightFocusValue = false;
    private Integer focusValueIndex;

    public BubbleGraph2DRenderer(int width, int height) {
        super(width, height);
    }

    @Override
    public void update(BubbleGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getFocusPixelX() != null) {
            this.focusPixelX = update.getFocusPixelX();
        }
        if (update.getFocusPixelY() != null) {
            this.focusPixelY = update.getFocusPixelY();
        }
        if (update.getHighlightFocusValue() != null) {
            this.highlightFocusValue = update.getHighlightFocusValue();
        }
    }

    protected void calculateRanges(Range xDataRange, Range xDisplayRange, Range yDataRange, Range yDisplayRange, Range zDataRange, Range zDisplayRange) {
        super.calculateRanges(xDataRange, xDisplayRange, yDataRange, yDisplayRange);
        this.zPlotRange = this.zAxisRange.axisRange(zDataRange, zDisplayRange);
    }

    public void draw(Graphics2D g, Point3DWithLabelDataset data) {
        if (g == null) {
            throw new NullPointerException("g is null");
        }
        this.g = g;
        this.calculateRanges((Range)data.getXStatistics(), data.getXDisplayRange(), (Range)data.getYStatistics(), data.getYDisplayRange(), (Range)data.getZStatistics(), data.getZDisplayRange());
        this.drawBackground();
        this.calculateLabels();
        this.calculateGraphArea();
        this.drawGraphArea();
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        LabelColorScheme labelColor = LabelColorSchemes.orderedHueColor(data.getLabels());
        ListInt indexes = ListNumbers.sortedView((ListNumber)data.getZValues()).getIndexes();
        this.focusValueIndex = null;
        boolean isFocusValuePresent = this.focusPixelX != null && this.focusPixelY != null;
        Shape focusShape = null;
        this.setClip(g);
        Range absZPlotRange = Ranges.absRange((Range)this.zPlotRange);
        for (int j = indexes.size() - 1; j >= 0; --j) {
            double deltaY;
            double deltaX;
            int i = indexes.getInt(j);
            double zValue = data.getZValues().getDouble(i);
            double diameter = this.radiusScale(absZPlotRange.getMinimum().doubleValue(), Math.abs(zValue), absZPlotRange.getMaximum().doubleValue(), 3.0, 15.0);
            double x = this.scaledX(data.getXValues().getDouble(i));
            double y = this.scaledY(data.getYValues().getDouble(i));
            Shape bubble = this.createShape(x, y, diameter, zValue >= 0.0);
            this.newValue(x, y, diameter, i);
            g.setColor(new Color(labelColor.getColor(data.getLabels().get(i))));
            g.fill(bubble);
            g.setColor(Color.BLACK);
            g.draw(bubble);
            if (!isFocusValuePresent || !(Math.sqrt((deltaX = (double)this.focusPixelX.intValue() - x) * deltaX + (deltaY = (double)this.focusPixelY.intValue() - y) * deltaY) < diameter / 2.0)) continue;
            this.focusValueIndex = i;
            focusShape = bubble;
        }
        if (this.highlightFocusValue && focusShape != null) {
            g.setColor(Color.WHITE);
            g.fill(focusShape);
            g.setColor(Color.BLACK);
            g.draw(focusShape);
        }
    }

    private double radiusScale(double minValue, double value, double maxValue, double minRadius, double maxRadius) {
        if (minValue < 0.0) {
            throw new UnsupportedOperationException("No negative value should be reaching here");
        }
        if (minValue == maxValue) {
            return minRadius + (maxRadius - minRadius) / 2.0;
        }
        if (value <= minValue) {
            return minRadius;
        }
        if (value >= maxValue) {
            return maxRadius;
        }
        return minRadius + MathUtil.scale(Math.sqrt(value), Math.sqrt(minValue), Math.sqrt(maxValue), maxRadius - minRadius);
    }

    protected void newValue(double x, double y, double size, int index) {
    }

    private Shape createShape(double x, double y, double size, boolean positive) {
        double halfSize = size / 2.0;
        if (positive) {
            Ellipse2D.Double circle = new Ellipse2D.Double(x - halfSize, y - halfSize, size, size);
            return circle;
        }
        Rectangle2D.Double square = new Rectangle2D.Double(x - halfSize, y - halfSize, size, size);
        return square;
    }

    @Override
    public BubbleGraph2DRendererUpdate newUpdate() {
        return new BubbleGraph2DRendererUpdate();
    }

    public Integer getFocusValueIndex() {
        return this.focusValueIndex;
    }
}

