/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DHistogramDataset;
import org.epics.graphene.Point1DDataset;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

public class Cell1DDatasets {
    public static Cell1DDataset linearRange(final ListNumber values, double minValue, double maxValue) {
        final Statistics statistics = StatisticsUtil.statisticsOf((CollectionNumber)values);
        final Range range = Ranges.range((double)minValue, (double)maxValue);
        final ListNumber xBoundaries = ListNumbers.linearListFromRange((double)minValue, (double)maxValue, (int)(values.size() + 1));
        return new Cell1DDataset(){

            @Override
            public Range getDisplayRange() {
                return null;
            }

            @Override
            public double getValue(int x) {
                return values.getDouble(x);
            }

            @Override
            public Statistics getStatistics() {
                return statistics;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return range;
            }

            @Override
            public int getXCount() {
                return values.size();
            }
        };
    }

    public static Cell1DDataset datasetFrom(final ListNumber values, final ListNumber xBoundaries) {
        final Statistics statistics = StatisticsUtil.statisticsOf((CollectionNumber)values);
        final Range range = Ranges.range((double)xBoundaries.getDouble(0), (double)xBoundaries.getDouble(xBoundaries.size() - 1));
        return new Cell1DDataset(){

            @Override
            public Range getDisplayRange() {
                return null;
            }

            @Override
            public double getValue(int x) {
                return values.getDouble(x);
            }

            @Override
            public Statistics getStatistics() {
                return statistics;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return range;
            }

            @Override
            public int getXCount() {
                return values.size();
            }
        };
    }

    public static Cell1DDataset datasetFrom(final ListNumber values, final ListNumber xBoundaries, final Range displayRange) {
        final Statistics statistics = StatisticsUtil.statisticsOf((CollectionNumber)values);
        final Range range = Ranges.range((double)xBoundaries.getDouble(0), (double)xBoundaries.getDouble(xBoundaries.size() - 1));
        return new Cell1DDataset(){

            @Override
            public Range getDisplayRange() {
                return displayRange;
            }

            @Override
            public double getValue(int x) {
                return values.getDouble(x);
            }

            @Override
            public Statistics getStatistics() {
                return statistics;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return range;
            }

            @Override
            public int getXCount() {
                return values.size();
            }
        };
    }

    public static Cell1DDataset createHistogram(Point1DDataset dataset) {
        Cell1DHistogramDataset histogram = new Cell1DHistogramDataset(dataset);
        return histogram;
    }
}

