/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.MathUtil;
import org.epics.graphene.Point1DDataset;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

class Cell1DHistogramDataset
implements Cell1DDataset {
    private Statistics statistics;
    private Range xRange;
    private ListNumber xBoundaries;
    private double minValueRange;
    private double maxValueRange;
    private int minCountRange;
    private int maxCountRange;
    private double[] values;
    private boolean autoValueRange = true;
    private int nBins = 100;

    public Cell1DHistogramDataset(Point1DDataset dataset) {
        this.calculateFrom(dataset);
    }

    private void calculateFrom(Point1DDataset dataset) {
        if (dataset.getStatistics() == null) {
            throw new NullPointerException("dataset is null");
        }
        IteratorNumber newValues = dataset.getValues().iterator();
        if (this.autoValueRange) {
            this.minValueRange = dataset.getStatistics().getMinimum().doubleValue();
            this.maxValueRange = dataset.getStatistics().getMaximum().doubleValue();
            this.xBoundaries = ListNumbers.linearListFromRange((double)this.minValueRange, (double)this.maxValueRange, (int)this.nBins);
            this.xRange = Ranges.range((double)this.xBoundaries.getDouble(0), (double)this.xBoundaries.getDouble(this.nBins));
        }
        this.values = new double[this.nBins];
        while (newValues.hasNext()) {
            this.addValueToBin(newValues.nextDouble());
        }
        this.statistics = StatisticsUtil.statisticsOf((CollectionNumber)new ArrayDouble(this.values));
    }

    private void addValueToBin(double value) {
        if (!Ranges.contains((Range)this.xRange, (double)value)) {
            return;
        }
        int bin = (int)Math.floor(MathUtil.scale(value, this.xRange.getMinimum().doubleValue(), this.xRange.getMaximum().doubleValue(), this.nBins));
        if (bin == this.nBins) {
            // empty if block
        }
        int n = --bin;
        this.values[n] = this.values[n] + 1.0;
    }

    @Override
    public double getValue(int x) {
        return this.values[x];
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public Range getDisplayRange() {
        return null;
    }

    @Override
    public ListNumber getXBoundaries() {
        return this.xBoundaries;
    }

    @Override
    public Range getXRange() {
        return this.xRange;
    }

    @Override
    public int getXCount() {
        return this.values.length;
    }
}

