/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Cell2DDataset;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

public class Cell2DDatasets {
    public static Cell2DDataset linearRange(final ListNumber data, final Range xRange, final int xCount, final Range yRange, final int yCount) {
        if (data.size() == 0) {
            throw new IllegalArgumentException("Empty Dataset. zData size = " + data.size());
        }
        if (xCount <= 0 || yCount <= 0) {
            throw new IllegalArgumentException("Number of X (or Y) values must be greater than 0. xCount = " + xCount + " yCount = " + yCount);
        }
        if (xCount * (yCount - 1) + xCount - 1 != data.size() - 1) {
            throw new IllegalArgumentException("Unexpected number of X (or Y) values. Array length = " + data.size() + ", Predicted size(given X and Y) = " + (xCount * (yCount - 1) + xCount) + ", xCount = " + xCount + ", yCount = " + yCount);
        }
        final ListNumber xBoundaries = ListNumbers.linearListFromRange((double)xRange.getMinimum().doubleValue(), (double)xRange.getMaximum().doubleValue(), (int)(xCount + 1));
        final ListNumber yBoundaries = ListNumbers.linearListFromRange((double)yRange.getMinimum().doubleValue(), (double)yRange.getMaximum().doubleValue(), (int)(yCount + 1));
        final Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)data);
        return new Cell2DDataset(){

            @Override
            public double getValue(int x, int y) {
                return data.getDouble(y * xCount + x);
            }

            @Override
            public Statistics getStatistics() {
                return stats;
            }

            @Override
            public Range getDisplayRange() {
                return stats;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return xRange;
            }

            @Override
            public int getXCount() {
                return xCount;
            }

            @Override
            public ListNumber getYBoundaries() {
                return yBoundaries;
            }

            @Override
            public Range getYRange() {
                return yRange;
            }

            @Override
            public int getYCount() {
                return yCount;
            }
        };
    }

    public static Cell2DDataset linearRange(final Function2D function, final Range xRange, final int xCount, final Range yRange, final int yCount) {
        final ListNumber xBoundaries = ListNumbers.linearListFromRange((double)xRange.getMinimum().doubleValue(), (double)xRange.getMaximum().doubleValue(), (int)(xCount + 1));
        final ListNumber yBoundaries = ListNumbers.linearListFromRange((double)yRange.getMinimum().doubleValue(), (double)yRange.getMaximum().doubleValue(), (int)(yCount + 1));
        final double xHalfStep = (xBoundaries.getDouble(1) - xBoundaries.getDouble(0)) / 2.0;
        final double yHalfStep = (yBoundaries.getDouble(1) - yBoundaries.getDouble(0)) / 2.0;
        CollectionDouble data = new CollectionDouble(){

            public IteratorDouble iterator() {
                return new IteratorDouble(){
                    int x;
                    int y;

                    public boolean hasNext() {
                        return this.y < yCount;
                    }

                    public double nextDouble() {
                        double value = function.getValue(xBoundaries.getDouble(this.x) + xHalfStep, yBoundaries.getDouble(this.y) + yHalfStep);
                        ++this.x;
                        if (this.x == xCount) {
                            this.x = 0;
                            ++this.y;
                        }
                        return value;
                    }
                };
            }

            public int size() {
                return xCount * yCount;
            }
        };
        final Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)data);
        return new Cell2DDataset(){

            @Override
            public double getValue(int x, int y) {
                return function.getValue(xBoundaries.getDouble(x) + xHalfStep, yBoundaries.getDouble(y) + yHalfStep);
            }

            @Override
            public Statistics getStatistics() {
                return stats;
            }

            @Override
            public Range getDisplayRange() {
                return stats;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return xRange;
            }

            @Override
            public int getXCount() {
                return xCount;
            }

            @Override
            public ListNumber getYBoundaries() {
                return yBoundaries;
            }

            @Override
            public Range getYRange() {
                return yRange;
            }

            @Override
            public int getYCount() {
                return yCount;
            }
        };
    }

    public static Cell2DDataset datasetFrom(Function2D function, ListNumber xBoundaries, ListNumber yBoundaries) {
        int yCount = yBoundaries.size() - 1;
        int xCount = xBoundaries.size() - 1;
        double[] values = new double[yCount * xCount];
        for (int y = 0; y < yCount; ++y) {
            double middleY = (yBoundaries.getDouble(y) + yBoundaries.getDouble(y + 1)) / 2.0;
            for (int x = 0; x < xCount; ++x) {
                double middleX = (xBoundaries.getDouble(x) + xBoundaries.getDouble(x + 1)) / 2.0;
                values[y * xCount + x] = function.getValue(middleX, middleY);
            }
        }
        ArrayDouble data = new ArrayDouble(values);
        return Cell2DDatasets.datasetFrom((ListNumber)data, xBoundaries, yBoundaries);
    }

    public static Cell2DDataset datasetFrom(final ListNumber values, final ListNumber xBoundaries, final ListNumber yBoundaries) {
        final Statistics statistics = StatisticsUtil.statisticsOf((CollectionNumber)values);
        final Range xRange = Ranges.range((double)xBoundaries.getDouble(0), (double)xBoundaries.getDouble(xBoundaries.size() - 1));
        final Range yRange = Ranges.range((double)yBoundaries.getDouble(0), (double)yBoundaries.getDouble(yBoundaries.size() - 1));
        final int xCount = xBoundaries.size() - 1;
        final int yCount = yBoundaries.size() - 1;
        if (values.size() != xCount * yCount) {
            throw new IllegalArgumentException("Number of boundaries do not match number of cells (" + xCount + " * " + yCount + " !+ " + values.size() + ")");
        }
        return new Cell2DDataset(){

            @Override
            public double getValue(int x, int y) {
                return values.getDouble(y * xCount + x);
            }

            @Override
            public Statistics getStatistics() {
                return statistics;
            }

            @Override
            public Range getDisplayRange() {
                return statistics;
            }

            @Override
            public ListNumber getXBoundaries() {
                return xBoundaries;
            }

            @Override
            public Range getXRange() {
                return xRange;
            }

            @Override
            public int getXCount() {
                return xCount;
            }

            @Override
            public ListNumber getYBoundaries() {
                return yBoundaries;
            }

            @Override
            public Range getYRange() {
                return yRange;
            }

            @Override
            public int getYCount() {
                return yCount;
            }
        };
    }

    public static interface Function2D {
        public double getValue(double var1, double var3);
    }
}

