/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.epics.graphene.GraphBuffer;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInt;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;

class GraphAreaData {
    GraphBuffer graphBuffer;
    Range xValueRange;
    Range yValueRange;
    ValueScale xValueScale;
    ValueScale yValueScale;
    Font labelFont;
    Color labelColor;
    Color referenceLineColor;
    ListInt xReferencePixels;
    ListDouble xReferenceValues;
    List<String> xReferenceLabels;
    int labelMarginBottom;
    int xLabelMaxHeight;
    ListInt yReferencePixels;
    ListDouble yReferenceValues;
    List<String> yReferenceLabels;
    int labelMarginLeft;
    int yLabelMaxWidth;
    int graphLeft;
    int graphRight;
    int graphBottom;
    int graphTop;
    int areaLeft;
    int areaRight;
    int areaBottom;
    int areaTop;
    int graphPaddingLeft = 0;
    int graphPaddingRight = 0;
    int graphPaddingBottom = 0;
    int graphPaddingTop = 0;

    GraphAreaData() {
    }

    public void setGraphBuffer(GraphBuffer graphBuffer) {
        this.graphBuffer = graphBuffer;
    }

    public void setGraphArea(int areaLeft, int areaBottom, int areaRight, int areaTop) {
        this.areaLeft = areaLeft;
        this.areaBottom = areaBottom;
        this.areaRight = areaRight;
        this.areaTop = areaTop;
    }

    public void setGraphPadding(int graphPaddingLeft, int graphPaddingBottom, int graphPaddingRight, int graphPaddingTop) {
        this.graphPaddingLeft = graphPaddingLeft;
        this.graphPaddingBottom = graphPaddingBottom;
        this.graphPaddingRight = graphPaddingRight;
        this.graphPaddingTop = graphPaddingTop;
    }

    public void setLabelMargin(int labelMarginBottom, int labelMarginLeft) {
        this.labelMarginBottom = labelMarginBottom;
        this.labelMarginLeft = labelMarginLeft;
    }

    public void setRanges(Range xValueRange, ValueScale xValueScale, Range yValueRange, ValueScale yValueScale) {
        this.xValueRange = xValueRange;
        this.yValueRange = yValueRange;
        this.xValueScale = xValueScale;
        this.yValueScale = yValueScale;
    }

    public void prepareLabels(Font labelFont, Color labelColor) {
        this.labelFont = labelFont;
        this.labelColor = labelColor;
        if (!this.xValueRange.getMinimum().equals(this.xValueRange.getMaximum())) {
            ValueAxis xAxis = this.xValueScale.references(this.xValueRange, 2, Math.max(2, (this.areaRight - this.areaLeft + 1) / 55));
            this.xReferenceLabels = Arrays.asList(xAxis.getTickLabels());
            this.xReferenceValues = new ArrayDouble(xAxis.getTickValues());
        } else {
            this.xReferenceLabels = Collections.singletonList(this.xValueRange.getMinimum().toString());
            this.xReferenceValues = new ArrayDouble(new double[]{this.xValueRange.getMinimum().doubleValue()});
        }
        if (!this.yValueRange.getMinimum().equals(this.yValueRange.getMaximum())) {
            ValueAxis yAxis = this.yValueScale.references(this.yValueRange, 2, Math.max(2, (this.areaBottom - this.areaTop + 1) / 55));
            this.yReferenceLabels = Arrays.asList(yAxis.getTickLabels());
            this.yReferenceValues = new ArrayDouble(yAxis.getTickValues());
        } else {
            this.yReferenceLabels = Collections.singletonList(this.yValueRange.getMinimum().toString());
            this.yReferenceValues = new ArrayDouble(new double[]{this.yValueRange.getMinimum().doubleValue()});
        }
        FontMetrics labelFontMetrics = this.graphBuffer.getGraphicsContext().getFontMetrics(labelFont);
        this.xLabelMaxHeight = labelFontMetrics.getHeight() - labelFontMetrics.getLeading();
        int[] yLabelWidths = new int[this.yReferenceLabels.size()];
        this.yLabelMaxWidth = 0;
        for (int i = 0; i < yLabelWidths.length; ++i) {
            yLabelWidths[i] = labelFontMetrics.stringWidth(this.yReferenceLabels.get(i));
            this.yLabelMaxWidth = Math.max(this.yLabelMaxWidth, yLabelWidths[i]);
        }
    }

    private Range safeRange(Range range) {
        if (range.getMinimum().doubleValue() == range.getMaximum().doubleValue()) {
            return Ranges.range((double)(range.getMinimum().doubleValue() - 1.0), (double)(range.getMaximum().doubleValue() + 1.0));
        }
        return range;
    }

    public void prepareGraphArea(boolean asCell, Color referenceLineColor) {
        int i;
        this.referenceLineColor = referenceLineColor;
        this.graphLeft = this.areaLeft + this.yLabelMaxWidth + this.labelMarginLeft;
        this.graphRight = this.areaRight;
        if (asCell) {
            this.graphBuffer.setXScaleAsCell(this.safeRange(this.xValueRange), this.graphLeft + this.graphPaddingLeft, this.graphRight - this.graphPaddingRight, this.xValueScale);
        } else {
            this.graphBuffer.setXScaleAsPoint(this.safeRange(this.xValueRange), this.graphLeft + this.graphPaddingLeft, this.graphRight - this.graphPaddingRight, this.xValueScale);
        }
        this.graphTop = this.areaTop;
        this.graphBottom = this.areaBottom - this.xLabelMaxHeight - this.labelMarginBottom;
        if (asCell) {
            this.graphBuffer.setYScaleAsCell(this.safeRange(this.yValueRange), this.graphBottom - this.graphPaddingBottom, this.graphTop + this.graphPaddingTop, this.yValueScale);
        } else {
            this.graphBuffer.setYScaleAsPoint(this.safeRange(this.yValueRange), this.graphBottom - this.graphPaddingBottom, this.graphTop + this.graphPaddingTop, this.yValueScale);
        }
        if (this.xReferenceValues != null) {
            int[] xRefCoords = new int[this.xReferenceValues.size()];
            for (i = 0; i < xRefCoords.length; ++i) {
                xRefCoords[i] = this.graphBuffer.xValueToPixel(this.xReferenceValues.getDouble(i));
            }
            if (asCell && xRefCoords[this.xReferenceValues.size() - 1] == this.graphRight + 1) {
                int n = this.xReferenceValues.size() - 1;
                xRefCoords[n] = xRefCoords[n] - 1;
            }
            this.xReferencePixels = new ArrayInt(xRefCoords);
        }
        if (this.yReferenceValues != null) {
            int[] yRefCoords = new int[this.yReferenceValues.size()];
            for (i = 0; i < yRefCoords.length; ++i) {
                yRefCoords[i] = this.graphBuffer.yValueToPixel(this.yReferenceValues.getDouble(i));
            }
            if (asCell && yRefCoords[this.yReferenceValues.size() - 1] == this.graphTop - 1) {
                int n = this.yReferenceValues.size() - 1;
                yRefCoords[n] = yRefCoords[n] + 1;
            }
            this.yReferencePixels = new ArrayInt(yRefCoords);
        }
    }

    protected void drawGraphArea() {
        this.graphBuffer.getGraphicsContext().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphBuffer.drawVerticalReferenceLines(this.xReferencePixels, this.referenceLineColor, this.graphBottom, this.graphTop);
        this.graphBuffer.drawHorizontalReferenceLines(this.yReferencePixels, this.referenceLineColor, this.graphLeft, this.graphRight);
        this.graphBuffer.drawBottomLabels(this.xReferenceLabels, this.xReferencePixels, this.labelColor, this.labelFont, this.graphLeft, this.graphRight, this.graphBottom + this.labelMarginBottom + 1);
        this.graphBuffer.drawLeftLabels(this.yReferenceLabels, this.yReferencePixels, this.labelColor, this.labelFont, this.graphBottom, this.graphTop, this.graphLeft - this.labelMarginLeft - 1);
    }
}

