/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.epics.util.array.IteratorDouble;
import org.epics.util.array.IteratorNumber;

public class Iterators {
    public static IteratorDouble arrayIterator(final double[] data) {
        return new IteratorDouble(){
            int index = 0;

            public boolean hasNext() {
                return this.index < data.length;
            }

            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                double value = data[this.index];
                ++this.index;
                return value;
            }
        };
    }

    public static IteratorDouble combine(final Collection<IteratorNumber> iterators) {
        return new IteratorDouble(){
            private IteratorNumber currentIterator = null;
            private Iterator<IteratorNumber> iterator = iterators.iterator();

            public boolean hasNext() {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return true;
                }
                if (this.iterator.hasNext()) {
                    this.currentIterator = this.iterator.next();
                    return this.hasNext();
                }
                return false;
            }

            public double nextDouble() {
                return this.currentIterator.nextDouble();
            }
        };
    }
}

