/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.ReductionScheme;

public class LineGraph2DRendererUpdate
extends Graph2DRendererUpdate<LineGraph2DRendererUpdate> {
    private NumberColorMap valueColorScheme;
    private InterpolationScheme interpolation;
    private ReductionScheme reduction;
    private Integer focusPixelX;
    private Boolean highlightFocusValue;

    public LineGraph2DRendererUpdate valueColorScheme(NumberColorMap scheme) {
        this.valueColorScheme = scheme;
        return (LineGraph2DRendererUpdate)this.self();
    }

    public LineGraph2DRendererUpdate interpolation(InterpolationScheme scheme) {
        if (scheme == null) {
            throw new NullPointerException("Interpolation scheme can't be null");
        }
        if (!LineGraph2DRenderer.supportedInterpolationScheme.contains((Object)scheme)) {
            throw new IllegalArgumentException("Interpolation " + (Object)((Object)scheme) + " is not supported");
        }
        this.interpolation = scheme;
        return this;
    }

    public LineGraph2DRendererUpdate dataReduction(ReductionScheme scheme) {
        if (scheme == null) {
            throw new NullPointerException("Data reduction scheme can't be null");
        }
        if (!LineGraph2DRenderer.supportedReductionScheme.contains((Object)scheme)) {
            throw new IllegalArgumentException("Data reduction " + (Object)((Object)scheme) + " is not supported");
        }
        this.reduction = scheme;
        return this;
    }

    public LineGraph2DRendererUpdate focusPixel(int x) {
        this.focusPixelX = x;
        return this;
    }

    public LineGraph2DRendererUpdate highlightFocusValue(boolean highlightFocusValue) {
        this.highlightFocusValue = highlightFocusValue;
        return this;
    }

    public NumberColorMap getValueColorScheme() {
        return this.valueColorScheme;
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    public ReductionScheme getDataReduction() {
        return this.reduction;
    }

    public Integer getFocusPixelX() {
        return this.focusPixelX;
    }

    public Boolean getHighlightFocusValue() {
        return this.highlightFocusValue;
    }
}

