/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.text.NumberFormat;
import org.epics.graphene.MathUtil;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.util.array.CircularBufferDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListDouble;
import org.epics.util.stats.Range;
import org.epics.util.text.NumberFormats;

final class LogValueScale
implements ValueScale {
    LogValueScale() {
    }

    @Override
    public double scaleValue(double value, double minValue, double maxValue, double newMinValue, double newMaxValue) {
        value = Math.log10(value);
        minValue = Math.log10(minValue);
        maxValue = Math.log10(maxValue);
        double oldRange = maxValue - minValue;
        double newRange = newMaxValue - newMinValue;
        return newMinValue + (value - minValue) / oldRange * newRange;
    }

    @Override
    public double invScaleValue(double scaleValue, double actualMinValue, double actualMaxValue, double scaleMinValue, double scaleMaxValue) {
        actualMinValue = Math.log10(actualMinValue);
        actualMaxValue = Math.log10(actualMaxValue);
        double actualRange = actualMaxValue - actualMinValue;
        double scaleRange = scaleMaxValue - scaleMinValue;
        return Math.pow(10.0, actualMinValue + (scaleValue - scaleMinValue) / scaleRange * actualRange);
    }

    @Override
    public ValueAxis references(Range range, int minRefs, int maxRefs) {
        NumberFormat format;
        boolean useExponentialNotation;
        double minValue = range.getMinimum().doubleValue();
        double maxValue = range.getMaximum().doubleValue();
        if (minValue == 0.0 || maxValue == 0.0) {
            throw new IllegalArgumentException("The range for a log scale can't include 0");
        }
        if (Math.signum(minValue) != Math.signum(maxValue)) {
            throw new IllegalArgumentException("The range for a log scale must be all positive or all negative");
        }
        int minExp = MathUtil.orderOf(minValue);
        int maxExp = MathUtil.orderOf(maxValue);
        int expRange = maxExp - minExp + 1;
        int maxRefsPerOrder = maxRefs / expRange;
        int currentFactor = LogValueScale.quantize(maxRefsPerOrder);
        ListDouble references = LogValueScale.generateReferenceValues(range, currentFactor);
        while (references.size() > maxRefs && currentFactor != 1) {
            currentFactor = LogValueScale.decreaseFactor(currentFactor);
            references = LogValueScale.generateReferenceValues(range, currentFactor);
        }
        int orderOfIncrement = MathUtil.orderOf(currentFactor);
        if (minExp - orderOfIncrement < -3 || maxExp > 3) {
            useExponentialNotation = true;
            format = NumberFormats.format((int)orderOfIncrement);
        } else {
            useExponentialNotation = false;
            format = NumberFormats.format((int)(orderOfIncrement - minExp));
        }
        String[] labels = new String[references.size()];
        for (int i = 0; i < references.size(); ++i) {
            double value = references.getDouble(i);
            labels[i] = useExponentialNotation ? LogValueScale.format(value, format, Integer.toString(MathUtil.orderOf(value)), Math.pow(10.0, MathUtil.orderOf(value))) : LogValueScale.format(value, format, null, 1.0);
        }
        return new ValueAxis(minValue, maxValue, CollectionNumbers.doubleArrayCopyOf((CollectionNumber)references), labels);
    }

    static String format(double number, NumberFormat format, String exponent, double normalization) {
        if (exponent != null) {
            return format.format(number / normalization) + "e" + exponent;
        }
        return format.format(number / normalization);
    }

    static int decreaseFactor(int factor) {
        if (factor == 1) {
            return 1;
        }
        int order = 1;
        while (factor >= 10) {
            factor /= 10;
            order *= 10;
        }
        if (factor == 1) {
            return order / 2;
        }
        if (factor == 5) {
            return order * 2;
        }
        if (factor == 2) {
            return order;
        }
        throw new IllegalStateException("Logic error: this should be unreachable");
    }

    static int quantize(double value) {
        if (value <= 1.0) {
            return 1;
        }
        int exp = MathUtil.orderOf(value);
        double order = Math.pow(10.0, exp);
        double normalizedValue = value / order;
        if (normalizedValue <= 1.0) {
            normalizedValue = 1.0;
        } else if (normalizedValue <= 2.0) {
            normalizedValue = 2.0;
        } else if (normalizedValue <= 5.0) {
            normalizedValue = 5.0;
        } else if (normalizedValue <= 10.0) {
            normalizedValue = 10.0;
        } else {
            throw new IllegalStateException("Logic error: this should be unreachable");
        }
        return (int)(normalizedValue * order);
    }

    static ListDouble generateReferenceValues(Range range, int subdivisionFactor) {
        CircularBufferDouble values = new CircularBufferDouble(100000);
        double minValue = range.getMinimum().doubleValue();
        double maxValue = range.getMaximum().doubleValue();
        int minExp = MathUtil.orderOf(minValue);
        int maxExp = MathUtil.orderOf(maxValue);
        for (int currentExp = minExp; currentExp <= maxExp; ++currentExp) {
            double currentOrder = Math.pow(10.0, currentExp);
            if (currentOrder <= maxValue && currentOrder >= minValue) {
                values.addDouble(currentOrder);
            }
            for (int i = 0; i < subdivisionFactor; ++i) {
                double newValue = currentOrder * 10.0 * (double)i / (double)subdivisionFactor;
                if (!(newValue <= maxValue) || !(newValue > currentOrder) || !(newValue > minValue)) continue;
                values.addDouble(newValue);
            }
        }
        return values;
    }
}

