/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.epics.graphene.AxisRangeInstance;
import org.epics.graphene.AxisRanges;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.InterpolationScheme;
import org.epics.graphene.Java2DStringUtilities;
import org.epics.graphene.MathIgnoreNaN;
import org.epics.graphene.MultiAxisLineGraph2DRendererUpdate;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.NumberColorMaps;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.ReductionScheme;
import org.epics.graphene.ValueAxis;
import org.epics.graphene.ValueScale;
import org.epics.graphene.ValueScales;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.array.SortedListView;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;

public class MultiAxisLineGraph2DRenderer
extends Graph2DRenderer<MultiAxisLineGraph2DRendererUpdate> {
    public static List<InterpolationScheme> supportedInterpolationScheme = Arrays.asList(InterpolationScheme.NEAREST_NEIGHBOR, InterpolationScheme.LINEAR, InterpolationScheme.CUBIC);
    public static List<ReductionScheme> supportedReductionScheme = Arrays.asList(ReductionScheme.FIRST_MAX_MIN_LAST, ReductionScheme.NONE);
    public static final InterpolationScheme DEFAULT_INTERPOLATION_SCHEME = InterpolationScheme.NEAREST_NEIGHBOR;
    public static final ReductionScheme DEFAULT_REDUCTION_SCHEME = ReductionScheme.FIRST_MAX_MIN_LAST;
    public static final boolean DEFAULT_SEPARATE_AREAS = false;
    private InterpolationScheme interpolation = DEFAULT_INTERPOLATION_SCHEME;
    private ReductionScheme reduction = DEFAULT_REDUCTION_SCHEME;
    private List<ListDouble> yReferenceCoords;
    private List<ListDouble> yReferenceValues;
    private List<List<String>> yReferenceLabels;
    private Range emptyRange;
    private AxisRangeInstance xAxisRange = AxisRanges.auto().createInstance();
    private AxisRangeInstance yAxisRange = AxisRanges.auto().createInstance();
    private List<AxisRangeInstance> yAxisRanges;
    private ValueScale xValueScale = ValueScales.linearScale();
    private ValueScale yValueScale = ValueScales.linearScale();
    private Range xAggregatedRange;
    private List<Range> yAggregatedRange;
    private Range xPlotRange;
    private List<Range> yPlotRange;
    private HashMap<Integer, Range> indexToRangeMap = new HashMap();
    private int numGraphs = 0;
    private int spaceForYAxes;
    private int minimumGraphWidth = 200;
    private int yLabelMaxWidth = 0;
    private int xLabelMaxHeight;
    private NumberColorMap valueColorScheme = NumberColorMaps.JET;
    private NumberColorMapInstance valueColorSchemeInstance;
    private double xPlotValueStart;
    private List<Double> yPlotValueStart;
    private double xPlotValueEnd;
    private List<Double> yPlotValueEnd;
    private ArrayList<Double> graphBoundaries;
    private ArrayList<Double> graphBoundaryRatios;
    private int marginBetweenGraphs = 0;
    private int totalYMargins = 0;
    private int minimumGraphHeight = 100;
    protected List<String> xReferenceLabels;
    private int xAreaCoordStart;
    private List<Integer> yAreaCoordStart;
    private List<Integer> yAreaCoordEnd;
    private int xAreaCoordEnd;
    private double xPlotCoordStart;
    private List<Double> yPlotCoordStart;
    private List<Double> yPlotCoordEnd;
    private double xPlotCoordEnd;
    private List<Double> yPlotCoordHeight;
    private double xPlotCoordWidth;
    private boolean stretch = false;
    private boolean separateAreas = false;
    private static final int MIN = 0;
    private static final int MAX = 1;

    @Override
    public MultiAxisLineGraph2DRendererUpdate newUpdate() {
        return new MultiAxisLineGraph2DRendererUpdate();
    }

    public MultiAxisLineGraph2DRenderer(int imageWidth, int imageHeight) {
        super(imageWidth, imageHeight);
    }

    public InterpolationScheme getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void update(MultiAxisLineGraph2DRendererUpdate update) {
        super.update(update);
        if (update.getInterpolation() != null) {
            this.interpolation = update.getInterpolation();
        }
        if (update.getDataReduction() != null) {
            this.reduction = update.getDataReduction();
        }
        if (update.getMinimumGraphWidth() != null) {
            this.minimumGraphWidth = update.getMinimumGraphWidth();
        }
        if (update.getImageHeight() != null) {
            if (this.stretch) {
                for (int i = 0; i < this.graphBoundaries.size(); ++i) {
                    this.graphBoundaries.set(i, (double)this.getImageHeight() * this.graphBoundaryRatios.get(i));
                }
            } else if ((double)this.getImageHeight() / (double)this.numGraphs - (double)this.totalYMargins >= (double)(this.minimumGraphHeight * 2)) {
                ++this.numGraphs;
            }
            if ((double)this.getImageHeight() / (double)this.numGraphs - (double)this.totalYMargins <= (double)this.minimumGraphHeight) {
                this.numGraphs = 0;
            }
        }
        if (update.getIndexToRange() != null) {
            this.indexToRangeMap = update.getIndexToRange();
        }
        if (update.getMarginBetweenGraphs() != null) {
            this.marginBetweenGraphs = update.getMarginBetweenGraphs();
        }
        if (update.getMinimumGraphHeight() != null) {
            this.minimumGraphHeight = update.getMinimumGraphHeight();
        }
        if (update.isSeparateAreas() != null) {
            this.separateAreas = update.isSeparateAreas();
        }
    }

    public void draw(Graphics2D g, List<Point2DDataset> data) {
        int i;
        Range datasetRange;
        this.g = g;
        ArrayList<Range> dataRangesX = new ArrayList<Range>();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            dataRangesX.add((Range)data.get(i2).getXStatistics());
        }
        ArrayList<Range> dataRangesY = new ArrayList<Range>();
        for (int i3 = 0; i3 < data.size(); ++i3) {
            dataRangesY.add((Range)data.get(i3).getYStatistics());
        }
        this.labelFontMetrics = g.getFontMetrics(this.labelFont);
        if (this.separateAreas) {
            this.xLabelMaxHeight = this.labelFontMetrics.getHeight() - this.labelFontMetrics.getLeading();
            this.totalYMargins = this.xLabelMaxHeight + this.marginBetweenGraphs + this.topMargin + this.bottomMargin + this.topAreaMargin + this.bottomAreaMargin + this.xLabelMargin + 1;
            this.getNumGraphsSplit(data);
            datasetRange = Ranges.range((double)0.0, (double)(this.numGraphs - 1));
            this.valueColorSchemeInstance = this.valueColorScheme.createInstance(datasetRange);
            this.calculateRanges(dataRangesX, dataRangesY, this.numGraphs);
            this.setGraphBoundaries(data);
            this.calculateLabels();
            this.calculateGraphAreaSplit();
            this.drawBackground();
            this.drawGraphArea();
        } else {
            this.getNumGraphs(data);
            datasetRange = Ranges.range((double)0.0, (double)(this.numGraphs - 1));
            this.valueColorSchemeInstance = this.valueColorScheme.createInstance(datasetRange);
            this.calculateRanges(dataRangesX, dataRangesY, this.numGraphs);
            this.calculateLabels();
            this.calculateGraphArea();
            this.drawBackground();
            this.drawGraphArea();
        }
        ArrayList<SortedListView> xValues = new ArrayList<SortedListView>();
        for (int i4 = 0; i4 < this.numGraphs; ++i4) {
            xValues.add(ListNumbers.sortedView((ListNumber)data.get(i4).getXValues()));
        }
        ArrayList<SortedListView> yValues = new ArrayList<SortedListView>();
        for (i = 0; i < this.numGraphs; ++i) {
            yValues.add(ListNumbers.sortedView((ListNumber)data.get(i).getYValues(), (ListInt)((SortedListView)xValues.get(i)).getIndexes()));
        }
        if (this.separateAreas) {
            g.setColor(Color.BLACK);
            for (i = 0; i < this.numGraphs; ++i) {
                this.drawValueExplicitLine((ListNumber)xValues.get(i), (ListNumber)yValues.get(i), this.interpolation, this.reduction, i);
            }
        } else {
            for (i = 0; i < this.numGraphs; ++i) {
                g.setColor(new Color(this.valueColorSchemeInstance.colorFor(i)));
                this.drawValueExplicitLine((ListNumber)xValues.get(i), (ListNumber)yValues.get(i), this.interpolation, this.reduction, i);
            }
        }
    }

    private void getNumGraphs(List<Point2DDataset> data) {
        this.numGraphs = data.size();
        if (this.yLabelMaxWidth == 0) {
            this.yLabelMaxWidth = 15;
        }
        this.spaceForYAxes = this.leftMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs - this.numGraphs / 2) - 1;
        this.spaceForYAxes = this.numGraphs > 1 ? (this.spaceForYAxes += this.rightMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs / 2) + 1) : (this.spaceForYAxes += this.rightMargin);
        while ((double)this.getImageWidth() - (double)this.spaceForYAxes < (double)this.minimumGraphWidth) {
            --this.numGraphs;
            this.spaceForYAxes = this.leftMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs - this.numGraphs / 2) - 1;
            if (this.numGraphs > 1) {
                this.spaceForYAxes += this.rightMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs / 2) + 1;
                continue;
            }
            this.spaceForYAxes += this.rightMargin;
        }
    }

    private void getNumGraphsSplit(List<Point2DDataset> data) {
        if (this.graphBoundaries == null || this.graphBoundaries.size() != this.numGraphs + 1) {
            this.numGraphs = data.size();
            while ((double)this.getImageHeight() / (double)this.numGraphs - (double)this.totalYMargins < (double)this.minimumGraphHeight) {
                --this.numGraphs;
            }
        }
        this.stretch = this.numGraphs == data.size();
    }

    private void setGraphBoundaries(List<Point2DDataset> data) {
        if (this.graphBoundaries == null || this.graphBoundaries.size() != this.numGraphs + 1) {
            double i;
            this.graphBoundaries = new ArrayList();
            for (i = 0.0; i <= (double)this.numGraphs; i += 1.0) {
                if (this.stretch) {
                    if (i > 0.0) {
                        this.graphBoundaries.add(i / (double)this.numGraphs * (double)this.getImageHeight() + (double)this.marginBetweenGraphs);
                        continue;
                    }
                    this.graphBoundaries.add(i / (double)this.numGraphs * (double)this.getImageHeight());
                    continue;
                }
                if (i > 0.0) {
                    this.graphBoundaries.add(i * (double)(this.minimumGraphHeight + this.totalYMargins));
                    continue;
                }
                this.graphBoundaries.add(i * (double)this.minimumGraphHeight);
            }
            this.graphBoundaryRatios = new ArrayList();
            for (i = 0.0; i <= (double)this.numGraphs; i += 1.0) {
                if (this.stretch) {
                    this.graphBoundaryRatios.add(i / (double)this.numGraphs);
                    continue;
                }
                this.graphBoundaryRatios.add(i * (double)this.minimumGraphHeight / (double)this.getImageHeight());
            }
        }
    }

    protected void calculateRanges(List<Range> xDataRange, List<Range> yDataRange, int length) {
        int i;
        for (i = 0; i < length; ++i) {
            this.xAggregatedRange = MultiAxisLineGraph2DRenderer.aggregateRange(xDataRange.get(i), this.xAggregatedRange);
            this.xPlotRange = this.xAxisRange.axisRange(xDataRange.get(i), xDataRange.get(i));
        }
        if (this.yAggregatedRange == null || yDataRange.size() != this.yAggregatedRange.size() || yDataRange.size() != length) {
            this.yAggregatedRange = new ArrayList<Range>();
            this.yPlotRange = new ArrayList<Range>();
            this.yAxisRanges = new ArrayList<AxisRangeInstance>();
            for (i = 0; i < length; ++i) {
                if (this.indexToRangeMap.isEmpty() || !this.indexToRangeMap.containsKey(i)) {
                    this.yAggregatedRange.add(MultiAxisLineGraph2DRenderer.aggregateRange(yDataRange.get(i), this.emptyRange));
                    AxisRangeInstance instance = this.yAxisRange.getAxisRange().createInstance();
                    this.yAxisRanges.add(instance);
                    this.yPlotRange.add(instance.axisRange(yDataRange.get(i), yDataRange.get(i)));
                    continue;
                }
                if (!this.indexToRangeMap.containsKey(i)) continue;
                this.yAggregatedRange.add(MultiAxisLineGraph2DRenderer.aggregateRange(yDataRange.get(i), this.emptyRange));
                this.yPlotRange.add(this.indexToRangeMap.get(i));
            }
        } else {
            for (i = 0; i < length; ++i) {
                if (this.indexToRangeMap.isEmpty() || !this.indexToRangeMap.containsKey(i)) {
                    this.yAggregatedRange.set(i, MultiAxisLineGraph2DRenderer.aggregateRange(yDataRange.get(i), this.yAggregatedRange.get(i)));
                    this.yPlotRange.set(i, this.yAxisRanges.get(i).axisRange(yDataRange.get(i), yDataRange.get(i)));
                    continue;
                }
                if (!this.indexToRangeMap.containsKey(i)) continue;
                this.yPlotRange.set(i, this.indexToRangeMap.get(i));
            }
        }
    }

    @Override
    protected void calculateLabels() {
        ValueAxis yAxis;
        int i;
        if (!this.xPlotRange.getMinimum().equals(this.xPlotRange.getMaximum())) {
            ValueAxis xAxis = this.xValueScale.references(this.xPlotRange, 2, Math.max(2, this.getImageWidth() / 60));
            this.xReferenceLabels = Arrays.asList(xAxis.getTickLabels());
            this.xReferenceValues = new ArrayDouble(xAxis.getTickValues());
        } else {
            this.xReferenceLabels = Collections.singletonList(this.xPlotRange.getMinimum().toString());
            this.xReferenceValues = new ArrayDouble(new double[]{this.xPlotRange.getMinimum().doubleValue()});
        }
        if (this.yReferenceLabels == null || this.yReferenceLabels.size() != this.numGraphs) {
            this.yReferenceLabels = new ArrayList<List<String>>();
            this.yReferenceValues = new ArrayList<ListDouble>();
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                if (!this.yPlotRange.get(i).getMinimum().equals(this.yPlotRange.get(i).getMaximum())) {
                    yAxis = this.separateAreas ? this.yValueScale.references(this.yPlotRange.get(i), 2, Math.max(2, (this.graphBoundaries.get(i + 1).intValue() - this.graphBoundaries.get(i).intValue()) / 60)) : this.yValueScale.references(this.yPlotRange.get(i), 2, Math.max(2, this.getImageHeight() / 60));
                    this.yReferenceLabels.add(Arrays.asList(yAxis.getTickLabels()));
                    this.yReferenceValues.add((ListDouble)new ArrayDouble(yAxis.getTickValues()));
                    continue;
                }
                this.yReferenceLabels.add(Collections.singletonList(this.yPlotRange.get(i).getMinimum().toString()));
                this.yReferenceValues.add((ListDouble)new ArrayDouble(new double[]{this.yPlotRange.get(i).getMinimum().doubleValue()}));
            }
        } else {
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                if (!this.yPlotRange.get(i).getMinimum().equals(this.yPlotRange.get(i).getMaximum())) {
                    yAxis = this.separateAreas ? this.yValueScale.references(this.yPlotRange.get(i), 2, Math.max(2, (this.graphBoundaries.get(i + 1).intValue() - this.graphBoundaries.get(i).intValue()) / 60)) : this.yValueScale.references(this.yPlotRange.get(i), 2, Math.max(2, this.getImageHeight() / 60));
                    this.yReferenceLabels.set(i, Arrays.asList(yAxis.getTickLabels()));
                    this.yReferenceValues.set(i, (ListDouble)new ArrayDouble(yAxis.getTickValues()));
                    continue;
                }
                this.yReferenceLabels.set(i, Collections.singletonList(this.yPlotRange.get(i).getMinimum().toString()));
                this.yReferenceValues.set(i, (ListDouble)new ArrayDouble(new double[]{this.yPlotRange.get(i).getMinimum().doubleValue()}));
            }
        }
        this.labelFontMetrics = this.g.getFontMetrics(this.labelFont);
        this.xLabelMaxHeight = this.labelFontMetrics.getHeight() - this.labelFontMetrics.getLeading();
        int yLabelWidth = 0;
        this.yLabelMaxWidth = 0;
        for (int a = 0; a < this.yReferenceLabels.size(); ++a) {
            for (int b = 0; b < this.yReferenceLabels.get(a).size(); ++b) {
                yLabelWidth = this.labelFontMetrics.stringWidth(this.yReferenceLabels.get(a).get(b));
                this.yLabelMaxWidth = Math.max(this.yLabelMaxWidth, yLabelWidth);
            }
        }
    }

    @Override
    protected void calculateGraphArea() {
        int i;
        int areaFromBottom = this.bottomMargin + this.xLabelMaxHeight + this.xLabelMargin;
        int areaFromLeft = this.leftMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs - this.numGraphs / 2) - 1;
        int areaFromRight = this.numGraphs > 1 ? this.rightMargin + (this.yLabelMaxWidth + this.yLabelMargin * 2 + 1) * (this.numGraphs / 2) + 1 : this.rightMargin;
        this.xPlotValueStart = this.xPlotRange.getMinimum().doubleValue();
        this.xPlotValueEnd = this.xPlotRange.getMaximum().doubleValue();
        if (this.xPlotValueStart == this.xPlotValueEnd) {
            this.xPlotValueStart -= 1.0;
            this.xPlotValueEnd += 1.0;
        }
        this.xAreaCoordStart = areaFromLeft;
        this.xAreaCoordEnd = this.getImageWidth() - areaFromRight;
        this.xPlotCoordStart = (double)(this.xAreaCoordStart + this.leftAreaMargin) + this.xPointMargin;
        this.xPlotCoordEnd = (double)(this.xAreaCoordEnd - this.rightAreaMargin) - this.xPointMargin;
        this.xPlotCoordWidth = this.xPlotCoordEnd - this.xPlotCoordStart;
        if (this.yPlotValueStart == null || this.yPlotValueStart.size() != this.yPlotRange.size()) {
            this.yPlotValueStart = new ArrayList<Double>();
            this.yPlotValueEnd = new ArrayList<Double>();
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                this.yPlotValueStart.add(this.yPlotRange.get(i).getMinimum().doubleValue());
                this.yPlotValueEnd.add(this.yPlotRange.get(i).getMaximum().doubleValue());
            }
        } else {
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                this.yPlotValueStart.set(i, this.yPlotRange.get(i).getMinimum().doubleValue());
                this.yPlotValueEnd.set(i, this.yPlotRange.get(i).getMaximum().doubleValue());
            }
        }
        for (i = 0; i < this.yPlotRange.size(); ++i) {
            if (this.yPlotValueStart.get(i).doubleValue() != this.yPlotValueEnd.get(i).doubleValue()) continue;
            this.yPlotValueStart.set(i, this.yPlotValueStart.get(i) - 1.0);
            this.yPlotValueEnd.set(i, this.yPlotValueEnd.get(i) + 1.0);
        }
        ((Graph2DRenderer)this).yAreaCoordStart = this.topMargin;
        ((Graph2DRenderer)this).yAreaCoordEnd = this.getImageHeight() - areaFromBottom;
        ((Graph2DRenderer)this).yPlotCoordStart = (double)(((Graph2DRenderer)this).yAreaCoordStart + this.topAreaMargin) + this.yPointMargin;
        ((Graph2DRenderer)this).yPlotCoordEnd = (double)(((Graph2DRenderer)this).yAreaCoordEnd - this.bottomAreaMargin) - this.yPointMargin;
        ((Graph2DRenderer)this).yPlotCoordHeight = ((Graph2DRenderer)this).yPlotCoordEnd - ((Graph2DRenderer)this).yPlotCoordStart;
        if (this.xReferenceValues != null) {
            double[] xRefCoords = new double[this.xReferenceValues.size()];
            for (int i2 = 0; i2 < xRefCoords.length; ++i2) {
                xRefCoords[i2] = this.scaledX1(this.xReferenceValues.getDouble(i2));
            }
            this.xReferenceCoords = new ArrayDouble(xRefCoords);
        }
        this.yReferenceCoords = new ArrayList<ListDouble>();
        if (this.yReferenceValues != null) {
            for (int a = 0; a < this.yReferenceValues.size(); ++a) {
                double[] yRefCoords = new double[this.yReferenceValues.get(a).size()];
                for (int b = 0; b < yRefCoords.length; ++b) {
                    yRefCoords[b] = this.separateAreas ? this.scaledYSplit(this.yReferenceValues.get(a).getDouble(b), a) : this.scaledY(this.yReferenceValues.get(a).getDouble(b), a);
                }
                this.yReferenceCoords.add((ListDouble)new ArrayDouble(yRefCoords));
            }
        }
    }

    protected void calculateGraphAreaSplit() {
        int i;
        int areaFromBottom = this.bottomMargin + this.xLabelMaxHeight + this.xLabelMargin;
        int areaFromLeft = this.leftMargin + this.yLabelMaxWidth + this.yLabelMargin;
        this.xPlotValueStart = this.xPlotRange.getMinimum().doubleValue();
        this.xPlotValueEnd = this.xPlotRange.getMaximum().doubleValue();
        if (this.xPlotValueStart == this.xPlotValueEnd) {
            this.xPlotValueStart -= 1.0;
            this.xPlotValueEnd += 1.0;
        }
        this.xAreaCoordStart = areaFromLeft;
        this.xAreaCoordEnd = this.getImageWidth() - this.rightMargin;
        this.xPlotCoordStart = (double)(this.xAreaCoordStart + this.leftAreaMargin) + this.xPointMargin;
        this.xPlotCoordEnd = (double)(this.xAreaCoordEnd - this.rightAreaMargin) - this.xPointMargin;
        this.xPlotCoordWidth = this.xPlotCoordEnd - this.xPlotCoordStart;
        if (this.yPlotValueStart == null || this.yPlotValueStart.size() != this.yPlotRange.size()) {
            this.yPlotValueStart = new ArrayList<Double>();
            this.yPlotValueEnd = new ArrayList<Double>();
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                this.yPlotValueStart.add(this.yPlotRange.get(i).getMinimum().doubleValue());
                this.yPlotValueEnd.add(this.yPlotRange.get(i).getMaximum().doubleValue());
            }
        } else {
            for (i = 0; i < this.yPlotRange.size(); ++i) {
                this.yPlotValueStart.set(i, this.yPlotRange.get(i).getMinimum().doubleValue());
                this.yPlotValueEnd.set(i, this.yPlotRange.get(i).getMaximum().doubleValue());
            }
        }
        for (i = 0; i < this.yPlotRange.size(); ++i) {
            if (this.yPlotValueStart.get(i).doubleValue() != this.yPlotValueEnd.get(i).doubleValue()) continue;
            this.yPlotValueStart.set(i, this.yPlotValueStart.get(i) - 1.0);
            this.yPlotValueEnd.set(i, this.yPlotValueEnd.get(i) + 1.0);
        }
        if (this.yAreaCoordStart == null || this.yAreaCoordStart.size() != this.numGraphs) {
            this.yAreaCoordStart = new ArrayList<Integer>();
            this.yAreaCoordEnd = new ArrayList<Integer>();
            this.yPlotCoordStart = new ArrayList<Double>();
            this.yPlotCoordEnd = new ArrayList<Double>();
            this.yPlotCoordHeight = new ArrayList<Double>();
            this.yAreaCoordStart.add(this.topMargin + this.graphBoundaries.get(0).intValue());
            this.yAreaCoordEnd.add(this.graphBoundaries.get(1).intValue() - areaFromBottom - this.marginBetweenGraphs);
            this.yPlotCoordStart.add((double)(this.yAreaCoordStart.get(0) + this.topAreaMargin) + this.yPointMargin);
            this.yPlotCoordEnd.add((double)(this.yAreaCoordEnd.get(0) - this.bottomAreaMargin) - this.yPointMargin);
            this.yPlotCoordHeight.add(this.yPlotCoordEnd.get(0) - this.yPlotCoordStart.get(0));
            for (i = 1; i < this.numGraphs - 1; ++i) {
                this.yAreaCoordStart.add(this.topMargin + this.graphBoundaries.get(i).intValue());
                this.yAreaCoordEnd.add(this.graphBoundaries.get(i + 1).intValue() - areaFromBottom - this.marginBetweenGraphs);
                this.yPlotCoordStart.add((double)(this.yAreaCoordStart.get(i) + this.topAreaMargin) + this.yPointMargin);
                this.yPlotCoordEnd.add((double)(this.yAreaCoordEnd.get(i) - this.bottomAreaMargin) - this.yPointMargin);
                this.yPlotCoordHeight.add(this.yPlotCoordEnd.get(i) - this.yPlotCoordStart.get(i));
            }
            this.yAreaCoordStart.add(this.topMargin + this.graphBoundaries.get(this.numGraphs - 1).intValue());
            this.yAreaCoordEnd.add(this.graphBoundaries.get(this.numGraphs).intValue() - areaFromBottom - this.marginBetweenGraphs);
            this.yPlotCoordStart.add((double)(this.yAreaCoordStart.get(this.numGraphs - 1) + this.topAreaMargin) + this.yPointMargin);
            this.yPlotCoordEnd.add((double)(this.yAreaCoordEnd.get(this.numGraphs - 1) - this.bottomAreaMargin) - this.yPointMargin);
            this.yPlotCoordHeight.add(this.yPlotCoordEnd.get(this.numGraphs - 1) - this.yPlotCoordStart.get(this.numGraphs - 1));
        } else {
            this.yAreaCoordStart.set(0, this.topMargin + this.graphBoundaries.get(0).intValue());
            this.yAreaCoordEnd.set(0, this.graphBoundaries.get(1).intValue() - areaFromBottom - this.marginBetweenGraphs);
            this.yPlotCoordStart.set(0, (double)(this.yAreaCoordStart.get(0) + this.topAreaMargin) + this.yPointMargin);
            this.yPlotCoordEnd.set(0, (double)(this.yAreaCoordEnd.get(0) - this.bottomAreaMargin) - this.yPointMargin);
            this.yPlotCoordHeight.set(0, this.yPlotCoordEnd.get(0) - this.yPlotCoordStart.get(0));
            for (i = 1; i < this.numGraphs - 1; ++i) {
                this.yAreaCoordStart.set(i, this.topMargin + this.graphBoundaries.get(i).intValue() + this.marginBetweenGraphs);
                this.yAreaCoordEnd.set(i, this.graphBoundaries.get(i + 1).intValue() - areaFromBottom - this.marginBetweenGraphs);
                this.yPlotCoordStart.set(i, (double)(this.yAreaCoordStart.get(i) + this.topAreaMargin) + this.yPointMargin);
                this.yPlotCoordEnd.set(i, (double)(this.yAreaCoordEnd.get(i) - this.bottomAreaMargin) - this.yPointMargin);
                this.yPlotCoordHeight.set(i, this.yPlotCoordEnd.get(i) - this.yPlotCoordStart.get(i));
            }
            this.yAreaCoordStart.set(this.numGraphs - 1, this.topMargin + this.graphBoundaries.get(this.numGraphs - 1).intValue());
            this.yAreaCoordEnd.set(this.numGraphs - 1, this.graphBoundaries.get(this.numGraphs).intValue() - areaFromBottom - this.marginBetweenGraphs);
            this.yPlotCoordStart.set(this.numGraphs - 1, (double)(this.yAreaCoordStart.get(this.numGraphs - 1) + this.topAreaMargin) + this.yPointMargin);
            this.yPlotCoordEnd.set(this.numGraphs - 1, (double)(this.yAreaCoordEnd.get(this.numGraphs - 1) - this.bottomAreaMargin) - this.yPointMargin);
            this.yPlotCoordHeight.set(this.numGraphs - 1, this.yPlotCoordEnd.get(this.numGraphs - 1) - this.yPlotCoordStart.get(this.numGraphs - 1));
        }
        if (this.xReferenceValues != null) {
            double[] xRefCoords = new double[this.xReferenceValues.size()];
            for (int i2 = 0; i2 < xRefCoords.length; ++i2) {
                xRefCoords[i2] = this.scaledX1(this.xReferenceValues.getDouble(i2));
            }
            this.xReferenceCoords = new ArrayDouble(xRefCoords);
        }
        this.yReferenceCoords = new ArrayList<ListDouble>();
        if (this.yReferenceValues != null) {
            for (int a = 0; a < this.yReferenceValues.size(); ++a) {
                double[] yRefCoords = new double[this.yReferenceValues.get(a).size()];
                for (int b = 0; b < yRefCoords.length; ++b) {
                    yRefCoords[b] = this.separateAreas ? this.scaledYSplit(this.yReferenceValues.get(a).getDouble(b), a) : this.scaledY(this.yReferenceValues.get(a).getDouble(b), a);
                }
                this.yReferenceCoords.add((ListDouble)new ArrayDouble(yRefCoords));
            }
        }
    }

    private final double scaledY(double value, int index) {
        return this.yValueScale.scaleValue(value, this.yPlotValueStart.get(index), this.yPlotValueEnd.get(index), ((Graph2DRenderer)this).yPlotCoordEnd, ((Graph2DRenderer)this).yPlotCoordStart);
    }

    private final double scaledYSplit(double value, int index) {
        return this.yValueScale.scaleValue(value, this.yPlotValueStart.get(index), this.yPlotValueEnd.get(index), this.yPlotCoordEnd.get(index), this.yPlotCoordStart.get(index));
    }

    @Override
    protected void drawGraphArea() {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.separateAreas) {
            this.drawVerticalReferenceLinesSplit();
            this.drawHorizontalReferenceLinesSplit();
            this.drawYLabelsSplit();
            this.drawXLabelsSplit();
        } else {
            this.drawVerticalReferenceLines();
            this.drawHorizontalReferenceLines();
            this.drawYLabels();
            this.drawXLabels();
        }
    }

    @Override
    protected void drawVerticalReferenceLines() {
        Line2D.Double line;
        int i;
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble xTicks = this.xReferenceCoords;
        for (int i2 = 0; i2 < xTicks.size(); ++i2) {
            Line2D.Double line2 = new Line2D.Double(xTicks.getDouble(i2), ((Graph2DRenderer)this).yAreaCoordStart, xTicks.getDouble(i2), ((Graph2DRenderer)this).yAreaCoordEnd - 1);
            this.g.draw(line2);
        }
        int count = 0;
        for (i = 0; i < this.numGraphs; i += 2) {
            this.g.setColor(new Color(this.valueColorSchemeInstance.colorFor(i)));
            line = new Line2D.Double(this.xAreaCoordStart - (count + 1) * (this.yLabelMargin + 1) - count * (this.yLabelMaxWidth + this.yLabelMargin), ((Graph2DRenderer)this).yAreaCoordStart, this.xAreaCoordStart - (count + 1) * (this.yLabelMargin + 1) - count * (this.yLabelMaxWidth + this.yLabelMargin), ((Graph2DRenderer)this).yAreaCoordEnd - 1);
            this.g.draw(line);
            ++count;
        }
        count = 0;
        for (i = 1; i < this.numGraphs; i += 2) {
            this.g.setColor(new Color(this.valueColorSchemeInstance.colorFor(i)));
            line = new Line2D.Double(this.xAreaCoordEnd + (count + 1) * (this.yLabelMargin + 1) + count * (this.yLabelMaxWidth + this.yLabelMargin), ((Graph2DRenderer)this).yAreaCoordStart, this.xAreaCoordEnd + (count + 1) * (this.yLabelMargin + 1) + count * (this.yLabelMaxWidth + this.yLabelMargin), ((Graph2DRenderer)this).yAreaCoordEnd - 1);
            this.g.draw(line);
            ++count;
        }
    }

    @Override
    protected void drawHorizontalReferenceLines() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListNumber yTicks = (ListNumber)this.yReferenceCoords.get(0);
        for (int b = 0; b < yTicks.size(); ++b) {
            Line2D.Double line = new Line2D.Double(this.xAreaCoordStart, yTicks.getDouble(b), this.xAreaCoordEnd - 1, yTicks.getDouble(b));
            this.g.draw(line);
        }
    }

    protected void drawVerticalReferenceLinesSplit() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ListDouble xTicks = this.xReferenceCoords;
        for (int a = 0; a < this.numGraphs; ++a) {
            for (int b = 0; b < xTicks.size(); ++b) {
                Line2D.Double line = new Line2D.Double(xTicks.getDouble(b), this.yAreaCoordStart.get(a).intValue(), xTicks.getDouble(b), this.yAreaCoordEnd.get(a) - 1);
                this.g.draw(line);
            }
        }
    }

    protected void drawHorizontalReferenceLinesSplit() {
        this.g.setColor(this.referenceLineColor);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int a = 0; a < this.numGraphs; ++a) {
            ListNumber yTicks = (ListNumber)this.yReferenceCoords.get(a);
            for (int b = 0; b < yTicks.size(); ++b) {
                Line2D.Double line = new Line2D.Double(this.xAreaCoordStart, yTicks.getDouble(b), this.xAreaCoordEnd - 1, yTicks.getDouble(b));
                this.g.draw(line);
            }
        }
    }

    @Override
    protected void drawYLabels() {
        int evenCount = 0;
        int oddCount = 0;
        for (int a = 0; a < this.numGraphs; ++a) {
            int verticalLinePos;
            int xRightLabel;
            ListNumber yTicks = (ListNumber)this.yReferenceCoords.get(a);
            if (this.yReferenceLabels.get(a) == null || this.yReferenceLabels.get(a).isEmpty()) continue;
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{((Graph2DRenderer)this).yAreaCoordStart, ((Graph2DRenderer)this).yAreaCoordEnd - 1};
            if (a % 2 == 0) {
                xRightLabel = this.xAreaCoordStart - (evenCount + 1) * (this.yLabelMargin + 1) * 2 - evenCount * (this.yLabelMaxWidth - 1);
                verticalLinePos = this.xAreaCoordStart - (evenCount + 1) * (this.yLabelMargin + 1) - evenCount * (this.yLabelMaxWidth + this.yLabelMargin);
                ++evenCount;
            } else {
                xRightLabel = this.xAreaCoordEnd + (oddCount + 1) * (this.yLabelMargin + 1) * 2 + (oddCount + 1) * this.yLabelMaxWidth - oddCount - 1;
                verticalLinePos = this.xAreaCoordEnd + (oddCount + 1) * (this.yLabelMargin + 1) + oddCount * (this.yLabelMaxWidth + this.yLabelMargin);
                ++oddCount;
            }
            MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(a).get(0), (int)Math.floor(yTicks.getDouble(0)), drawRange, xRightLabel, true, false, verticalLinePos);
            MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(a).get(this.yReferenceLabels.get(a).size() - 1), (int)Math.floor(yTicks.getDouble(this.yReferenceLabels.get(a).size() - 1)), drawRange, xRightLabel, false, false, verticalLinePos);
            for (int b = 1; b < this.yReferenceLabels.get(a).size() - 1; ++b) {
                MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabel(this.g, metrics, this.yReferenceLabels.get(a).get(b), (int)Math.floor(yTicks.getDouble(b)), drawRange, xRightLabel, true, false, verticalLinePos);
            }
        }
    }

    protected void drawYLabelsSplit() {
        for (int a = 0; a < this.numGraphs; ++a) {
            ListNumber yTicks = (ListNumber)this.yReferenceCoords.get(a);
            if (this.yReferenceLabels.get(a) == null || this.yReferenceLabels.get(a).isEmpty()) continue;
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.yAreaCoordStart.get(a), this.yAreaCoordEnd.get(a) - 1};
            int xRightLabel = this.xAreaCoordStart - this.yLabelMargin - 1;
            MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabelSplit(this.g, metrics, this.yReferenceLabels.get(a).get(0), (int)Math.floor(yTicks.getDouble(0)), drawRange, xRightLabel, true, false);
            MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabelSplit(this.g, metrics, this.yReferenceLabels.get(a).get(this.yReferenceLabels.get(a).size() - 1), (int)Math.floor(yTicks.getDouble(this.yReferenceLabels.get(a).size() - 1)), drawRange, xRightLabel, false, false);
            for (int b = 1; b < this.yReferenceLabels.get(a).size() - 1; ++b) {
                MultiAxisLineGraph2DRenderer.drawHorizontalReferencesLabelSplit(this.g, metrics, this.yReferenceLabels.get(a).get(b), (int)Math.floor(yTicks.getDouble(b)), drawRange, xRightLabel, true, false);
            }
        }
    }

    @Override
    protected void drawXLabels() {
        ListDouble xTicks = this.xReferenceCoords;
        if (this.xReferenceLabels != null && !this.xReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.xAreaCoordStart, this.xAreaCoordEnd - 1};
            int yTop = ((Graph2DRenderer)this).yAreaCoordEnd + this.xLabelMargin;
            MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(0), (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop, true, false);
            MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(this.xReferenceLabels.size() - 1), (int)Math.floor(xTicks.getDouble(this.xReferenceLabels.size() - 1)), drawRange, yTop, false, false);
            for (int i = 1; i < this.xReferenceLabels.size() - 1; ++i) {
                MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabel(this.g, metrics, this.xReferenceLabels.get(i), (int)Math.floor(xTicks.getDouble(i)), drawRange, yTop, true, false);
            }
        }
    }

    private static void drawVerticalReferenceLabel(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    protected void drawXLabelsSplit() {
        ListDouble xTicks = this.xReferenceCoords;
        if (this.xReferenceLabels != null && !this.xReferenceLabels.isEmpty()) {
            this.g.setColor(this.labelColor);
            this.g.setFont(this.labelFont);
            FontMetrics metrics = this.g.getFontMetrics();
            int[] drawRange = new int[]{this.xAreaCoordStart, this.xAreaCoordEnd - 1};
            int yTop = this.yAreaCoordEnd.get(this.numGraphs - 1) + this.xLabelMargin;
            MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabelSplit(this.g, metrics, this.xReferenceLabels.get(0), (int)Math.floor(xTicks.getDouble(0)), drawRange, yTop, true, false);
            MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabelSplit(this.g, metrics, this.xReferenceLabels.get(this.xReferenceLabels.size() - 1), (int)Math.floor(xTicks.getDouble(this.xReferenceLabels.size() - 1)), drawRange, yTop, false, false);
            for (int i = 1; i < this.xReferenceLabels.size() - 1; ++i) {
                MultiAxisLineGraph2DRenderer.drawVerticalReferenceLabelSplit(this.g, metrics, this.xReferenceLabels.get(i), (int)Math.floor(xTicks.getDouble(i)), drawRange, yTop, true, false);
            }
        }
    }

    private static void drawHorizontalReferencesLabel(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly, int verticalLinePos) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        graphics.drawLine(verticalLinePos - 1, targetY, verticalLinePos + 1, targetY);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    private static void drawHorizontalReferencesLabelSplit(Graphics2D graphics, FontMetrics metrics, String text, int yCenter, int[] drawRange, int xRight, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < yCenter || drawRange[0] > yCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.RIGHT;
        int targetY = yCenter;
        int halfHeight = metrics.getAscent() / 2;
        if (yCenter < drawRange[0] + halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetY = drawRange[0];
        } else if (yCenter > drawRange[1] - halfHeight) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.BOTTOM_RIGHT;
            targetY = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, xRight, targetY, text);
        if (updateMin) {
            drawRange[1] = targetY - metrics.getHeight();
        } else {
            drawRange[0] = targetY + metrics.getHeight();
        }
    }

    private static void drawVerticalReferenceLabelSplit(Graphics2D graphics, FontMetrics metrics, String text, int xCenter, int[] drawRange, int yTop, boolean updateMin, boolean centeredOnly) {
        if (drawRange[1] < xCenter || drawRange[0] > xCenter) {
            return;
        }
        if (drawRange[1] - drawRange[0] < metrics.getHeight()) {
            return;
        }
        Java2DStringUtilities.Alignment alignment = Java2DStringUtilities.Alignment.TOP;
        int targetX = xCenter;
        int halfWidth = metrics.stringWidth(text) / 2;
        if (xCenter < drawRange[0] + halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_LEFT;
            targetX = drawRange[0];
        } else if (xCenter > drawRange[1] - halfWidth) {
            if (centeredOnly) {
                return;
            }
            alignment = Java2DStringUtilities.Alignment.TOP_RIGHT;
            targetX = drawRange[1];
        }
        Java2DStringUtilities.drawString(graphics, alignment, targetX, yTop, text);
        if (updateMin) {
            drawRange[0] = targetX + metrics.getHeight();
        } else {
            drawRange[1] = targetX - metrics.getHeight();
        }
    }

    private final double scaledX1(double value) {
        return this.xValueScale.scaleValue(value, this.xPlotValueStart, this.xPlotValueEnd, this.xPlotCoordStart, this.xPlotCoordEnd);
    }

    protected void drawValueExplicitLine(ListNumber xValues, ListNumber yValues, InterpolationScheme interpolation, ReductionScheme reduction, int index) {
        Path2D.Double path;
        ScaledData scaledData;
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int start = ListNumbers.binarySearchValueOrLower((ListNumber)xValues, (double)this.xPlotValueStart);
        int end = ListNumbers.binarySearchValueOrHigher((ListNumber)xValues, (double)this.xPlotValueEnd);
        xValues = ListMath.limit((ListNumber)xValues, (int)start, (int)(end + 1));
        yValues = ListMath.limit((ListNumber)yValues, (int)start, (int)(end + 1));
        switch (reduction) {
            default: {
                throw new IllegalArgumentException("Reduction scheme " + (Object)((Object)reduction) + " not supported");
            }
            case NONE: {
                scaledData = this.scaleNoReduction(xValues, yValues, start, index);
                break;
            }
            case FIRST_MAX_MIN_LAST: {
                scaledData = this.scaleFirstMaxMinLastReduction(xValues, yValues, start, index);
            }
        }
        switch (interpolation) {
            default: {
                path = MultiAxisLineGraph2DRenderer.nearestNeighbour(scaledData);
                break;
            }
            case LINEAR: {
                path = MultiAxisLineGraph2DRenderer.linearInterpolation(scaledData);
                break;
            }
            case CUBIC: {
                path = MultiAxisLineGraph2DRenderer.cubicInterpolation(scaledData);
            }
        }
        this.g.draw(path);
    }

    private ScaledData scaleNoReduction(ListNumber xValues, ListNumber yValues, int dataStart, int index) {
        ScaledData scaledData = new ScaledData();
        int dataCount = xValues.size();
        ScaledData.access$102(scaledData, new double[dataCount]);
        ScaledData.access$202(scaledData, new double[dataCount]);
        for (int i = 0; i < scaledData.scaledY.length; ++i) {
            ((ScaledData)scaledData).scaledX[i] = this.scaledX1(xValues.getDouble(i));
            ((ScaledData)scaledData).scaledY[i] = this.separateAreas ? this.scaledYSplit(yValues.getDouble(i), index) : this.scaledY(yValues.getDouble(i), index);
            this.processScaledValue(dataStart + i, xValues.getDouble(i), yValues.getDouble(i), scaledData.scaledX[i], scaledData.scaledY[i]);
        }
        scaledData.end = dataCount;
        return scaledData;
    }

    private ScaledData scaleFirstMaxMinLastReduction(ListNumber xValues, ListNumber yValues, int dataStart, int index) {
        if ((double)xValues.size() < this.xPlotCoordWidth * 4.0) {
            return this.scaleNoReduction(xValues, yValues, dataStart, index);
        }
        ScaledData scaledData = new ScaledData();
        ScaledData.access$102(scaledData, new double[((int)this.xPlotCoordWidth + 1) * 4]);
        ScaledData.access$202(scaledData, new double[((int)this.xPlotCoordWidth + 1) * 4]);
        int cursor = 0;
        int previousPixel = (int)this.scaledX1(xValues.getDouble(0));
        double last = this.separateAreas ? this.scaledYSplit(yValues.getDouble(0), index) : this.scaledY(yValues.getDouble(0), index);
        double min = last;
        double max = last;
        ((ScaledData)scaledData).scaledX[0] = previousPixel;
        ((ScaledData)scaledData).scaledY[0] = min;
        this.processScaledValue(dataStart, xValues.getDouble(0), yValues.getDouble(0), this.scaledX1(xValues.getDouble(0)), last);
        ++cursor;
        for (int i = 1; i < xValues.size(); ++i) {
            double currentScaledX = this.scaledX1(xValues.getDouble(i));
            int currentPixel = (int)currentScaledX;
            if (currentPixel == previousPixel) {
                last = this.separateAreas ? this.scaledYSplit(yValues.getDouble(i), index) : this.scaledY(yValues.getDouble(i), index);
                min = MathIgnoreNaN.min(min, last);
                max = MathIgnoreNaN.max(max, last);
                this.processScaledValue(dataStart + i, xValues.getDouble(i), yValues.getDouble(i), currentScaledX, last);
                continue;
            }
            ((ScaledData)scaledData).scaledX[cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = max;
            ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = min;
            ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
            ((ScaledData)scaledData).scaledY[cursor] = last;
            previousPixel = currentPixel;
            last = this.separateAreas ? this.scaledYSplit(yValues.getDouble(i), index) : this.scaledY(yValues.getDouble(i), index);
            min = last;
            max = last;
            ((ScaledData)scaledData).scaledX[++cursor] = currentPixel;
            ((ScaledData)scaledData).scaledY[cursor] = last;
            ++cursor;
        }
        ((ScaledData)scaledData).scaledX[cursor] = previousPixel;
        ((ScaledData)scaledData).scaledY[cursor] = max;
        ((ScaledData)scaledData).scaledX[++cursor] = previousPixel;
        ((ScaledData)scaledData).scaledY[cursor] = min;
        scaledData.end = ++cursor;
        return scaledData;
    }

    private static Path2D.Double nearestNeighbour(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double line = new Path2D.Double();
        line.moveTo(scaledX[start], scaledY[start]);
        for (int i = 1; i < end; ++i) {
            double halfX = scaledX[i - 1] + (scaledX[i] - scaledX[i - 1]) / 2.0;
            if (!Double.isNaN(scaledY[i - 1])) {
                line.lineTo(halfX, scaledY[i - 1]);
                if (Double.isNaN(scaledY[i])) continue;
                line.lineTo(halfX, scaledY[i]);
                continue;
            }
            line.moveTo(halfX, scaledY[i]);
        }
        line.lineTo(scaledX[end - 1], scaledY[end - 1]);
        return line;
    }

    private static Path2D.Double linearInterpolation(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double line = new Path2D.Double();
        for (int i = start; i < end; ++i) {
            if (Double.isNaN(scaledY[i])) continue;
            if (i != start && !Double.isNaN(scaledY[i - 1])) {
                line.lineTo(scaledX[i], scaledY[i]);
                continue;
            }
            if (i != end - 1 && !Double.isNaN(scaledY[i + 1])) {
                line.moveTo(scaledX[i], scaledY[i]);
                continue;
            }
            line.moveTo(scaledX[i] - 1.0, scaledY[i]);
            line.lineTo(scaledX[i] + 1.0, scaledY[i]);
        }
        return line;
    }

    private static Path2D.Double cubicInterpolation(ScaledData scaledData) {
        double[] scaledX = scaledData.scaledX;
        double[] scaledY = scaledData.scaledY;
        int start = scaledData.start;
        int end = scaledData.end;
        Path2D.Double path = new Path2D.Double();
        for (int i = start; i < end; ++i) {
            if (Double.isNaN(scaledY[i])) continue;
            if (i > start && !Double.isNaN(scaledY[i - 1])) {
                double by2;
                double bx2;
                double by1;
                double bx1;
                double bdy3;
                double bdy0;
                double by3;
                double bx3;
                double by0;
                double bx0;
                double x1;
                double y1;
                double x3;
                double y3;
                double x0;
                double y0;
                double x2;
                double y2;
                if (i > start + 1 && !Double.isNaN(scaledY[i - 2])) {
                    if (i != end - 1 && !Double.isNaN(scaledY[i + 1])) {
                        y2 = scaledY[i];
                        x2 = scaledX[i];
                        y0 = scaledY[i - 2];
                        x0 = scaledX[i - 2];
                        y3 = scaledY[i + 1];
                        x3 = scaledX[i + 1];
                        y1 = scaledY[i - 1];
                        bx0 = x1 = scaledX[i - 1];
                        by0 = y1;
                        bx3 = x2;
                        by3 = y2;
                        bdy0 = (y2 - y0) / (x2 - x0);
                        bdy3 = (y3 - y1) / (x3 - x1);
                        bx1 = bx0 + (x2 - x0) / 6.0;
                        by1 = (bx1 - bx0) * bdy0 + by0;
                        bx2 = bx3 - (x3 - x1) / 6.0;
                        by2 = (bx2 - bx3) * bdy3 + by3;
                        path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                        continue;
                    }
                    y2 = scaledY[i];
                    x2 = scaledX[i];
                    y1 = scaledY[i - 1];
                    x1 = scaledX[i - 1];
                    y0 = scaledY[i - 2];
                    x0 = scaledX[i - 2];
                    y3 = y2 + (y2 - y1) / 2.0;
                    x3 = x2 + (x2 - x1) / 2.0;
                    bx0 = x1;
                    by0 = y1;
                    bx3 = x2;
                    by3 = y2;
                    bdy0 = (y2 - y0) / (x2 - x0);
                    bdy3 = (y3 - y1) / (x3 - x1);
                    bx1 = bx0 + (x2 - x0) / 6.0;
                    by1 = (bx1 - bx0) * bdy0 + by0;
                    bx2 = bx3 - (x3 - x1) / 6.0;
                    by2 = (bx2 - bx3) * bdy3 + by3;
                    path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                    continue;
                }
                if (i != end - 1 && !Double.isNaN(scaledY[i + 1])) {
                    path.moveTo(scaledX[i - 1], scaledY[i - 1]);
                    y2 = scaledY[i];
                    x2 = scaledX[i];
                    y1 = scaledY[i - 1];
                    x1 = scaledX[i - 1];
                    y0 = y1 - (y2 - y1) / 2.0;
                    x0 = x1 - (x2 - x1) / 2.0;
                    y3 = scaledY[i + 1];
                    x3 = scaledX[i + 1];
                    bx0 = x1;
                    by0 = y1;
                    bx3 = x2;
                    by3 = y2;
                    bdy0 = (y2 - y0) / (x2 - x0);
                    bdy3 = (y3 - y1) / (x3 - x1);
                    bx1 = bx0 + (x2 - x0) / 6.0;
                    by1 = (bx1 - bx0) * bdy0 + by0;
                    bx2 = bx3 - (x3 - x1) / 6.0;
                    by2 = (bx2 - bx3) * bdy3 + by3;
                    path.curveTo(bx1, by1, bx2, by2, bx3, by3);
                    continue;
                }
                path.lineTo(scaledX[i], scaledY[i]);
                continue;
            }
            if (i != end - 1 && !Double.isNaN(scaledY[i + 1])) {
                path.moveTo(scaledX[i], scaledY[i]);
                continue;
            }
            path.moveTo(scaledX[i] - 1.0, scaledY[i]);
            path.lineTo(scaledX[i] + 1.0, scaledY[i]);
        }
        return path;
    }

    private static class ScaledData {
        private double[] scaledX;
        private double[] scaledY;
        private int start;
        private int end;

        private ScaledData() {
        }

        static /* synthetic */ double[] access$102(ScaledData x0, double[] x1) {
            x0.scaledX = x1;
            return x1;
        }

        static /* synthetic */ double[] access$202(ScaledData x0, double[] x1) {
            x0.scaledY = x1;
            return x1;
        }
    }
}

