/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.epics.graphene.MathUtil;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.util.stats.Range;

class NumberColorMapGradient
implements NumberColorMap {
    private final Color[] colors;
    private final String name;

    public NumberColorMapGradient(Color[] colors, String name) {
        this.colors = colors;
        this.name = name;
    }

    @Override
    public NumberColorMapInstance createInstance(Range range) {
        return new ValueColorSchemeInstanceGradient(this.colors, range);
    }

    private static ArrayList<Double> percentageRange(int size) {
        ArrayList<Double> percentages = new ArrayList<Double>();
        percentages.add(0.0);
        for (int i = 1; i <= size; ++i) {
            percentages.add((double)i / (double)size);
        }
        return percentages;
    }

    public String toString() {
        return this.name;
    }

    class ValueColorSchemeInstanceGradient
    implements NumberColorMapInstance {
        protected Color[] colors;
        protected List<Double> percentages = new ArrayList<Double>();
        protected int nanColor;
        protected Range range;

        public ValueColorSchemeInstanceGradient(Color[] colors, Range range) {
            this.range = range;
            this.colors = colors;
            this.nanColor = colors[colors.length - 1].getRGB();
            this.percentages = NumberColorMapGradient.percentageRange(colors.length - 2);
        }

        @Override
        public int colorFor(double value) {
            if (Double.isNaN(value)) {
                return this.nanColor;
            }
            if (this.range == null) {
                throw new NullPointerException("range can not be null.");
            }
            double fullRange = this.range.getMaximum().doubleValue() - this.range.getMinimum().doubleValue();
            int alpha = 0;
            int red = 0;
            int green = 0;
            int blue = 0;
            if (fullRange > 0.0) {
                for (int i = 0; i < this.percentages.size() - 1; ++i) {
                    if (!(this.range.getMinimum().doubleValue() + this.percentages.get(i) * fullRange <= value) || !(value <= this.range.getMinimum().doubleValue() + this.percentages.get(i + 1) * fullRange)) continue;
                    double normalValue = MathUtil.normalize(value, this.range.getMinimum().doubleValue() + this.percentages.get(i) * fullRange, this.range.getMinimum().doubleValue() + this.percentages.get(i + 1) * fullRange);
                    normalValue = Math.min(normalValue, 1.0);
                    normalValue = Math.max(normalValue, 0.0);
                    alpha = 255;
                    red = (int)((double)this.colors[i].getRed() + (double)(this.colors[i + 1].getRed() - this.colors[i].getRed()) * normalValue);
                    green = (int)((double)this.colors[i].getGreen() + (double)(this.colors[i + 1].getGreen() - this.colors[i].getGreen()) * normalValue);
                    blue = (int)((double)this.colors[i].getBlue() + (double)(this.colors[i + 1].getBlue() - this.colors[i].getBlue()) * normalValue);
                }
            } else {
                for (int i = 0; i < this.percentages.size() - 1; ++i) {
                    if (!(this.percentages.get(i) <= 0.5) || !(0.5 <= this.percentages.get(i + 1))) continue;
                    double normalValue = 0.0;
                    normalValue = Math.min(normalValue, 1.0);
                    normalValue = Math.max(normalValue, 0.0);
                    alpha = 255;
                    red = (int)((double)this.colors[i].getRed() + (double)(this.colors[i + 1].getRed() - this.colors[i].getRed()) * normalValue);
                    green = (int)((double)this.colors[i].getGreen() + (double)(this.colors[i + 1].getGreen() - this.colors[i].getGreen()) * normalValue);
                    blue = (int)((double)this.colors[i].getBlue() + (double)(this.colors[i + 1].getBlue() - this.colors[i].getBlue()) * normalValue);
                }
            }
            if (value > this.range.getMaximum().doubleValue()) {
                alpha = 255;
                red = this.colors[this.colors.length - 2].getRed();
                green = this.colors[this.colors.length - 2].getGreen();
                blue = this.colors[this.colors.length - 2].getBlue();
            }
            if (value < this.range.getMinimum().doubleValue()) {
                alpha = 255;
                red = this.colors[0].getRed();
                green = this.colors[0].getGreen();
                blue = this.colors[0].getBlue();
            }
            return alpha << 24 | red << 16 | green << 8 | blue;
        }

        public String toString() {
            return NumberColorMapGradient.this.name + " " + this.range;
        }
    }
}

