/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.epics.graphene.NumberColorMap;
import org.epics.graphene.NumberColorMapGradient;
import org.epics.graphene.NumberColorMapInstance;
import org.epics.graphene.NumberColorMapInstanceOptimized;
import org.epics.util.stats.Range;

public class NumberColorMaps {
    public static final NumberColorMap JET = new NumberColorMapGradient(new Color[]{new Color(0, 0, 138), Color.BLUE, Color.CYAN, Color.YELLOW, Color.RED, new Color(138, 0, 0), Color.BLACK}, "JET");
    public static final NumberColorMap GRAY = new NumberColorMapGradient(new Color[]{Color.BLACK, Color.WHITE, Color.RED}, "GRAY");
    public static final NumberColorMap BONE = new NumberColorMapGradient(new Color[]{Color.BLACK, new Color(57, 57, 86), new Color(107, 115, 140), new Color(165, 198, 198), Color.WHITE, Color.RED}, "BONE");
    public static final NumberColorMap HOT = new NumberColorMapGradient(new Color[]{Color.BLACK, Color.RED, Color.YELLOW, Color.WHITE, Color.BLUE}, "HOT");
    public static final NumberColorMap HSV = new NumberColorMapGradient(new Color[]{Color.RED, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLUE, Color.MAGENTA, Color.RED, Color.BLACK}, "HSV");
    private static final Map<String, NumberColorMap> registeredColorSchemes = new ConcurrentHashMap<String, NumberColorMap>();

    public static Map<String, NumberColorMap> getRegisteredColorSchemes() {
        return Collections.unmodifiableMap(registeredColorSchemes);
    }

    public static NumberColorMapInstance optimize(NumberColorMapInstance instance, Range range) {
        return new NumberColorMapInstanceOptimized(instance, range);
    }

    public static NumberColorMapInstance optimize(NumberColorMapInstance instance, Range oldRange, Range newRange) {
        return new NumberColorMapInstanceOptimized(instance, oldRange, newRange);
    }

    static {
        registeredColorSchemes.put(JET.toString(), JET);
        registeredColorSchemes.put(GRAY.toString(), GRAY);
        registeredColorSchemes.put(BONE.toString(), BONE);
        registeredColorSchemes.put(HOT.toString(), HOT);
        registeredColorSchemes.put(HSV.toString(), HSV);
    }
}

