/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import org.epics.graphene.Point2DDataset;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

public class Point2DDatasets {
    public static Point2DDataset lineData(double[] data) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(data));
    }

    public static Point2DDataset lineData(ListNumber data) {
        return Point2DDatasets.lineData(ListNumbers.linearList((double)0.0, (double)1.0, (int)data.size()), data);
    }

    public static Point2DDataset lineData(double[] data, double xInitialOffset, double xIncrementSize) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(data), xInitialOffset, xIncrementSize);
    }

    public static Point2DDataset lineData(ListNumber data, double xInitialOffset, double xIncrementSize) {
        return Point2DDatasets.lineData(ListNumbers.linearList((double)xInitialOffset, (double)xIncrementSize, (int)data.size()), data);
    }

    public static Point2DDataset lineData(double[] x, double[] y) {
        return Point2DDatasets.lineData((ListNumber)new ArrayDouble(x), (ListNumber)new ArrayDouble(y));
    }

    public static Point2DDataset lineData(Range xRange, ListNumber y) {
        return Point2DDatasets.lineData(ListNumbers.linearListFromRange((double)xRange.getMinimum().doubleValue(), (double)xRange.getMaximum().doubleValue(), (int)y.size()), y);
    }

    public static Point2DDataset lineData(final ListNumber x, final ListNumber y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Arrays length don't match: " + x.size() + " - " + y.size());
        }
        return new Point2DDataset(){
            private final Statistics xStatistics;
            private final Statistics yStatistics;
            {
                this.xStatistics = StatisticsUtil.statisticsOf((CollectionNumber)x);
                this.yStatistics = StatisticsUtil.statisticsOf((CollectionNumber)y);
            }

            @Override
            public ListNumber getXValues() {
                return x;
            }

            @Override
            public ListNumber getYValues() {
                return y;
            }

            @Override
            public Statistics getXStatistics() {
                return this.xStatistics;
            }

            @Override
            public Statistics getYStatistics() {
                return this.yStatistics;
            }

            @Override
            public Range getXDisplayRange() {
                return null;
            }

            @Override
            public Range getYDisplayRange() {
                return null;
            }

            @Override
            public int getCount() {
                return x.size();
            }
        };
    }
}

