/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.util.List;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Range;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;

public class Point3DWithLabelDatasets {
    public static Point3DWithLabelDataset build(final ListNumber x, final ListNumber y, final ListNumber z, final List<String> labels) {
        if (x.size() != y.size() || x.size() != y.size() || x.size() != labels.size()) {
            throw new IllegalArgumentException("Array lengths don't match: " + x.size() + " - " + y.size() + " - " + z.size() + " - " + labels.size());
        }
        return new Point3DWithLabelDataset(){
            private final Statistics xStatistics;
            private final Statistics yStatistics;
            private final Statistics zStatistics;
            {
                this.xStatistics = StatisticsUtil.statisticsOf((CollectionNumber)x);
                this.yStatistics = StatisticsUtil.statisticsOf((CollectionNumber)y);
                this.zStatistics = StatisticsUtil.statisticsOf((CollectionNumber)z);
            }

            @Override
            public ListNumber getXValues() {
                return x;
            }

            @Override
            public ListNumber getYValues() {
                return y;
            }

            @Override
            public ListNumber getZValues() {
                return z;
            }

            @Override
            public List<String> getLabels() {
                return labels;
            }

            @Override
            public Statistics getXStatistics() {
                return this.xStatistics;
            }

            @Override
            public Statistics getYStatistics() {
                return this.yStatistics;
            }

            @Override
            public Statistics getZStatistics() {
                return this.zStatistics;
            }

            @Override
            public Range getXDisplayRange() {
                return null;
            }

            @Override
            public Range getYDisplayRange() {
                return null;
            }

            @Override
            public Range getZDisplayRange() {
                return null;
            }

            @Override
            public int getCount() {
                return x.size();
            }
        };
    }
}

