/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.epics.graphene.LinearAbsoluteTimeScale;
import org.epics.graphene.TimeScale;
import org.epics.util.array.ArrayInt;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;
import org.epics.util.time.TimestampFormat;

public class TimeScales {
    private static TimestampFormat format = new TimestampFormat("yyyy/MM/dd HH:mm:ss.NNNNNNNNN");
    private static ArrayInt possibleStopFromEnd = new ArrayInt(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 13, 19, 22, 25, 28});
    private static ArrayInt possibleStopFromStart = new ArrayInt(new int[]{0, 11, 19, 28});
    private static String zeroFormat = "0000/01/01 00:00:00.000000000";

    public static TimeScale linearAbsoluteScale() {
        return new LinearAbsoluteTimeScale();
    }

    static TimePeriod nextUp(TimePeriod period) {
        switch (period.fieldId) {
            case 14: {
                if (period.amount < 2.0) {
                    return new TimePeriod(14, 2.0);
                }
                if (period.amount < 5.0) {
                    return new TimePeriod(14, 5.0);
                }
                if (period.amount < 10.0) {
                    return new TimePeriod(14, 10.0);
                }
                if (period.amount < 20.0) {
                    return new TimePeriod(14, 20.0);
                }
                if (period.amount < 50.0) {
                    return new TimePeriod(14, 50.0);
                }
                if (period.amount < 100.0) {
                    return new TimePeriod(14, 100.0);
                }
                if (period.amount < 200.0) {
                    return new TimePeriod(14, 200.0);
                }
                if (period.amount < 500.0) {
                    return new TimePeriod(14, 500.0);
                }
                return new TimePeriod(13, 1.0);
            }
            case 13: {
                if (period.amount < 2.0) {
                    return new TimePeriod(13, 2.0);
                }
                if (period.amount < 5.0) {
                    return new TimePeriod(13, 5.0);
                }
                if (period.amount < 10.0) {
                    return new TimePeriod(13, 10.0);
                }
                if (period.amount < 15.0) {
                    return new TimePeriod(13, 15.0);
                }
                if (period.amount < 30.0) {
                    return new TimePeriod(13, 30.0);
                }
                return new TimePeriod(12, 1.0);
            }
        }
        return null;
    }

    static List<Timestamp> createReferences(TimeInterval timeInterval, TimePeriod period) {
        Date start = timeInterval.getStart().toDate();
        Date end = timeInterval.getEnd().toDate();
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(end);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        TimeScales.round(cal, period.fieldId);
        cal.set(period.fieldId, cal.get(period.fieldId) / (int)period.amount * (int)period.amount);
        ArrayList<Timestamp> references = new ArrayList<Timestamp>();
        while (endCal.compareTo(cal) >= 0) {
            Timestamp newTime = Timestamp.of((Date)cal.getTime());
            if (timeInterval.contains(newTime)) {
                references.add(newTime);
            }
            cal.add(period.fieldId, (int)period.amount);
        }
        return references;
    }

    static void round(GregorianCalendar cal, int field) {
        if (14 == field) {
            return;
        }
        cal.set(14, 0);
        if (13 == field) {
            return;
        }
        cal.set(13, 0);
        if (12 == field) {
            return;
        }
        cal.set(12, 0);
    }

    static TimePeriod nextDown(TimePeriod period) {
        switch (period.fieldId) {
            case 12: {
                return new TimePeriod(13, 30.0);
            }
            case 13: {
                if (period.amount > 30.0) {
                    return new TimePeriod(13, 30.0);
                }
                if (period.amount > 15.0) {
                    return new TimePeriod(13, 15.0);
                }
                if (period.amount > 10.0) {
                    return new TimePeriod(13, 10.0);
                }
                if (period.amount > 5.0) {
                    return new TimePeriod(13, 5.0);
                }
                if (period.amount > 2.0) {
                    return new TimePeriod(13, 2.0);
                }
                if (period.amount > 1.0) {
                    return new TimePeriod(13, 1.0);
                }
                return new TimePeriod(14, 500.0);
            }
            case 14: {
                if (period.amount > 500.0) {
                    return new TimePeriod(14, 500.0);
                }
                if (period.amount > 200.0) {
                    return new TimePeriod(14, 200.0);
                }
                if (period.amount > 100.0) {
                    return new TimePeriod(14, 100.0);
                }
                if (period.amount > 50.0) {
                    return new TimePeriod(14, 50.0);
                }
                if (period.amount > 20.0) {
                    return new TimePeriod(14, 20.0);
                }
                if (period.amount > 10.0) {
                    return new TimePeriod(14, 10.0);
                }
                if (period.amount > 5.0) {
                    return new TimePeriod(14, 5.0);
                }
                if (period.amount > 2.0) {
                    return new TimePeriod(14, 2.0);
                }
                if (!(period.amount > 1.0)) break;
                return new TimePeriod(14, 1.0);
            }
        }
        return null;
    }

    static TimePeriod toTimePeriod(double seconds) {
        if (seconds >= 60.0) {
            return new TimePeriod(12, seconds / 60.0);
        }
        if (seconds >= 1.0) {
            return new TimePeriod(13, seconds);
        }
        return new TimePeriod(14, 100.0 * seconds);
    }

    static double normalize(Timestamp time, TimeInterval timeInterval) {
        double range = timeInterval.getEnd().durationFrom(timeInterval.getStart()).toNanosLong();
        double value = time.durationBetween(timeInterval.getStart()).toNanosLong();
        return value / range;
    }

    static List<String> createLabels(List<Timestamp> timestamps) {
        if (timestamps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(timestamps.size());
        for (Timestamp timestamp : timestamps) {
            result.add(format.format(timestamp));
        }
        return result;
    }

    static int commonEnd(String a, String b) {
        int currentStopFromEnd = 0;
        while (a.charAt(b.length() - 1 - currentStopFromEnd) == b.charAt(b.length() - 1 - currentStopFromEnd)) {
            ++currentStopFromEnd;
        }
        return currentStopFromEnd;
    }

    static int commonStart(String a, String b) {
        int commonStart = 0;
        while (a.charAt(commonStart) == b.charAt(commonStart)) {
            ++commonStart;
        }
        return commonStart;
    }

    static List<String> trimLabelsRight(List<String> labels) {
        if (labels.isEmpty()) {
            return labels;
        }
        int currentStopFromEnd = zeroFormat.length();
        for (int i = 0; i < labels.size(); ++i) {
            String otherLabel = labels.get(i);
            currentStopFromEnd = Math.min(currentStopFromEnd, TimeScales.commonEnd(otherLabel, zeroFormat));
        }
        int finalStop = 0;
        int i = 0;
        while (possibleStopFromEnd.getInt(i) <= currentStopFromEnd) {
            finalStop = possibleStopFromEnd.getInt(i);
            ++i;
        }
        if (finalStop == 0) {
            return labels;
        }
        ArrayList<String> result = new ArrayList<String>(labels.size());
        for (String label : labels) {
            result.add(label.substring(0, zeroFormat.length() - finalStop));
        }
        return result;
    }

    static List<String> trimLabelsLeft(List<String> labels) {
        if (labels.isEmpty()) {
            return labels;
        }
        ArrayList<String> result = new ArrayList<String>(labels.size());
        String previousLabel = labels.get(0);
        result.add(previousLabel);
        for (int i = 1; i < labels.size(); ++i) {
            String nextLabel = labels.get(i);
            int commonStart = TimeScales.commonStart(previousLabel, nextLabel);
            int finalStart = 0;
            int j = 0;
            while (possibleStopFromStart.getInt(j) <= commonStart) {
                finalStart = possibleStopFromStart.getInt(j);
                ++j;
            }
            result.add(nextLabel.substring(finalStart, nextLabel.length()));
            previousLabel = nextLabel;
        }
        return result;
    }

    static class TimePeriod {
        public int fieldId;
        public double amount;

        public TimePeriod(int fieldId, double amount) {
            this.fieldId = fieldId;
            this.amount = amount;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + this.fieldId;
            hash = 59 * hash + (int)(Double.doubleToLongBits(this.amount) ^ Double.doubleToLongBits(this.amount) >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimePeriod other = (TimePeriod)obj;
            if (this.fieldId != other.fieldId) {
                return false;
            }
            return Double.doubleToLongBits(this.amount) == Double.doubleToLongBits(other.amount);
        }

        public String toString() {
            return "TimePeriod{fieldId=" + this.fieldId + ", amount=" + this.amount + '}';
        }
    }
}

