/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.util.List;
import org.epics.graphene.TimeScales;
import org.epics.graphene.TimeSeriesDataset;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;

public class TimeSeriesDatasets {
    public static TimeSeriesDataset timeSeriesOf(final ListNumber values, final List<Timestamp> timestamps) {
        final TimeInterval timeInterval = TimeInterval.between((Timestamp)timestamps.get(0), (Timestamp)timestamps.get(timestamps.size() - 1));
        final Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)values);
        return new TimeSeriesDataset(){

            @Override
            public ListNumber getValues() {
                return values;
            }

            @Override
            public List<Timestamp> getTimestamps() {
                return timestamps;
            }

            @Override
            public ListNumber getNormalizedTime() {
                return new ListDouble(){

                    public double getDouble(int index) {
                        return TimeScales.normalize((Timestamp)timestamps.get(index), timeInterval);
                    }

                    public int size() {
                        return timestamps.size();
                    }
                };
            }

            @Override
            public Statistics getStatistics() {
                return stats;
            }

            @Override
            public TimeInterval getTimeInterval() {
                return timeInterval;
            }

            @Override
            public int getCount() {
                return values.size();
            }
        };
    }
}

