/*
 * Decompiled with CFR 0.152.
 */
package org.epics.graphene;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.epics.graphene.FontUtil;
import org.epics.graphene.MathUtil;
import org.epics.graphene.ValueAxis;

class VerticalAxisRenderer {
    private ValueAxis axis;
    private Color axisTextColor = Color.BLACK;
    private FontMetrics metrics;
    private static Font defaultAxisFont = FontUtil.getLiberationSansRegular();
    private Font axisFont = defaultAxisFont;
    private int axisWidth;
    private int tickSize = 3;
    private int textTickMargin = 0;
    private String[] yLabels;
    private double[] yValueTicks;
    private int[] yLabelWidths;
    private int[] yTicks;

    VerticalAxisRenderer(ValueAxis valueAxis, int leftMargin, Graphics2D graphics) {
        this.axis = valueAxis;
        this.metrics = graphics.getFontMetrics(this.axisFont);
        this.yValueTicks = this.axis.getTickValues();
        this.yLabels = this.axis.getTickLabels();
        this.yLabelWidths = new int[this.yLabels.length];
        int yLargestLabel = 0;
        for (int i = 0; i < this.yLabelWidths.length; ++i) {
            this.yLabelWidths[i] = this.metrics.stringWidth(this.yLabels[i]);
            yLargestLabel = Math.max(yLargestLabel, this.yLabelWidths[i]);
        }
        this.axisWidth = leftMargin + yLargestLabel + this.textTickMargin + this.tickSize;
    }

    public void draw(Graphics2D graphics, int startImage, int startAxis, int endAxis, int endImage, int axisPosition) {
        int i;
        int plotHeight = endAxis - startAxis;
        int imageHeight = endImage - startImage;
        this.yTicks = new int[this.yLabels.length];
        for (i = 0; i < this.yTicks.length; ++i) {
            this.yTicks[i] = imageHeight - endAxis + (int)(MathUtil.normalize(this.yValueTicks[i], this.axis.getMinValue(), this.axis.getMaxValue()) * (double)plotHeight);
        }
        graphics.setColor(this.axisTextColor);
        graphics.setFont(this.axisFont);
        for (i = 0; i < this.yLabels.length; ++i) {
            int halfHeight = this.metrics.getAscent() / 2 - 1;
            graphics.drawString(this.yLabels[i], axisPosition - this.yLabelWidths[i] - this.textTickMargin - this.tickSize, imageHeight - this.yTicks[i] + halfHeight);
        }
    }

    public int getAxisWidth() {
        return this.axisWidth;
    }

    public int[] verticalTickPositions() {
        return this.yTicks;
    }
}

