/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.text.NumberFormat;
import java.util.List;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Display;
import org.epics.vtype.VNumberArray;

class AdaptiveRange
implements Display {
    private Double lowerDisplayLimit = 0.0;
    private Double lowerCtrlLimit = 0.0;
    private Double lowerAlarmLimit = 0.0;
    private Double lowerWarningLimit = 0.0;
    private Double upperWarningLimit = 0.0;
    private Double upperAlarmLimit = 0.0;
    private Double upperCtrlLimit = 0.0;
    private Double upperDisplayLimit = 0.0;
    private boolean firstValue = true;
    private boolean limitsChanged = false;

    AdaptiveRange() {
    }

    public boolean limitsChanged() {
        boolean returnValue = this.limitsChanged;
        this.limitsChanged = false;
        return returnValue;
    }

    public void considerValues(List<? extends VNumberArray> values) {
        for (VNumberArray vNumberArray : values) {
            this.considerValues(vNumberArray.getData());
        }
    }

    void considerValues(ListNumber array) {
        for (int i = 0; i < array.size(); ++i) {
            double d = array.getDouble(i);
            if (Double.isNaN(d)) continue;
            if (this.firstValue) {
                this.lowerDisplayLimit = d;
                this.lowerCtrlLimit = d;
                this.lowerAlarmLimit = d;
                this.lowerWarningLimit = d;
                this.upperWarningLimit = d;
                this.upperAlarmLimit = d;
                this.upperCtrlLimit = d;
                this.upperDisplayLimit = d;
                this.firstValue = false;
                this.limitsChanged = true;
                continue;
            }
            if (d > this.upperDisplayLimit) {
                this.upperWarningLimit = d;
                this.upperAlarmLimit = d;
                this.upperCtrlLimit = d;
                this.upperDisplayLimit = d;
                this.limitsChanged = true;
            }
            if (!(d < this.lowerDisplayLimit)) continue;
            this.lowerDisplayLimit = d;
            this.lowerCtrlLimit = d;
            this.lowerAlarmLimit = d;
            this.lowerWarningLimit = d;
            this.limitsChanged = true;
        }
    }

    public Double getLowerDisplayLimit() {
        return this.lowerDisplayLimit;
    }

    public Double getLowerCtrlLimit() {
        return this.lowerCtrlLimit;
    }

    public Double getLowerAlarmLimit() {
        return this.lowerAlarmLimit;
    }

    public Double getLowerWarningLimit() {
        return this.lowerWarningLimit;
    }

    public String getUnits() {
        throw new UnsupportedOperationException("Units not part of auto range");
    }

    public NumberFormat getFormat() {
        throw new UnsupportedOperationException("Format not part of auto range");
    }

    public Double getUpperWarningLimit() {
        return this.upperWarningLimit;
    }

    public Double getUpperAlarmLimit() {
        return this.upperAlarmLimit;
    }

    public Double getUpperCtrlLimit() {
        return this.upperCtrlLimit;
    }

    public Double getUpperDisplayLimit() {
        return this.upperDisplayLimit;
    }
}

