/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.extra.DoubleArrayTimeCache;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListNumber;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.TimeInterval;
import org.epics.util.time.Timestamp;
import org.epics.vtype.Display;
import org.epics.vtype.VNumber;

public class DoubleArrayTimeCacheFromVDoubles
implements DoubleArrayTimeCache {
    private NavigableMap<Timestamp, ArrayDouble> cache = new TreeMap<Timestamp, ArrayDouble>();
    private List<? extends ReadFunction<? extends List<? extends VNumber>>> functions;
    private Display display;
    private TimeDuration tolerance = TimeDuration.ofMillis((int)1);

    public DoubleArrayTimeCacheFromVDoubles(List<? extends ReadFunction<? extends List<? extends VNumber>>> functions) {
        this.functions = functions;
    }

    private ArrayDouble arrayFor(Timestamp timeStamp) {
        ArrayDouble array = (ArrayDouble)this.cache.get(timeStamp);
        if (array != null) {
            return array;
        }
        Timestamp newTime = this.cache.higherKey(timeStamp);
        if (newTime != null && newTime.minus(this.tolerance).compareTo(timeStamp) <= 0) {
            return (ArrayDouble)this.cache.get(newTime);
        }
        newTime = this.cache.lowerKey(timeStamp);
        if (newTime != null && newTime.plus(this.tolerance).compareTo(timeStamp) >= 0) {
            return (ArrayDouble)this.cache.get(newTime);
        }
        if (newTime != null) {
            array = new ArrayDouble(Arrays.copyOf(CollectionNumbers.wrappedDoubleArray((CollectionNumber)((CollectionNumber)this.cache.get(newTime))), this.functions.size()), false);
        } else {
            double[] blank = new double[this.functions.size()];
            Arrays.fill(blank, Double.NaN);
            array = new ArrayDouble(blank, false);
        }
        this.cache.put(timeStamp, array);
        return array;
    }

    @Override
    public DoubleArrayTimeCache.Data getData(Timestamp begin, Timestamp end) {
        for (int n = 0; n < this.functions.size(); ++n) {
            List vDoubles = (List)this.functions.get(n).readValue();
            for (VNumber vNumber : vDoubles) {
                if (this.display == null) {
                    this.display = vNumber;
                }
                ArrayDouble array = this.arrayFor(vNumber.getTimestamp());
                double oldValue = array.getDouble(n);
                array.setDouble(n, vNumber.getValue().doubleValue());
                for (Map.Entry<Timestamp, ArrayDouble> en : this.cache.tailMap(vNumber.getTimestamp().plus(this.tolerance)).entrySet()) {
                    if (!Double.isNaN(en.getValue().getDouble(n)) && en.getValue().getDouble(n) != oldValue) continue;
                    en.getValue().setDouble(n, vNumber.getValue().doubleValue());
                }
            }
        }
        if (this.cache.isEmpty()) {
            return null;
        }
        Timestamp newBegin = this.cache.lowerKey(begin);
        if (newBegin == null) {
            newBegin = (Timestamp)this.cache.firstKey();
        }
        this.deleteBefore(begin);
        return this.data(newBegin, end);
    }

    private List<TimeInterval> update() {
        Timestamp firstChange = null;
        Timestamp lastChange = null;
        for (int n = 0; n < this.functions.size(); ++n) {
            List vNumbers = (List)this.functions.get(n).readValue();
            for (VNumber vNumber : vNumbers) {
                if (this.display == null) {
                    this.display = vNumber;
                }
                ArrayDouble array = this.arrayFor(vNumber.getTimestamp());
                double oldValue = array.getDouble(n);
                array.setDouble(n, vNumber.getValue().doubleValue());
                if (firstChange == null) {
                    firstChange = vNumber.getTimestamp();
                }
                if (lastChange == null) {
                    lastChange = vNumber.getTimestamp();
                }
                firstChange = this.min(firstChange, vNumber.getTimestamp());
                lastChange = this.max(lastChange, vNumber.getTimestamp());
                for (Map.Entry<Timestamp, ArrayDouble> en : this.cache.tailMap(vNumber.getTimestamp().plus(this.tolerance)).entrySet()) {
                    if (!Double.isNaN(en.getValue().getDouble(n)) && en.getValue().getDouble(n) != oldValue) continue;
                    en.getValue().setDouble(n, vNumber.getValue().doubleValue());
                }
            }
        }
        if (firstChange == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(TimeInterval.between((Timestamp)firstChange.minus(this.tolerance), lastChange));
    }

    private void deleteBefore(Timestamp timeStamp) {
        if (this.cache.isEmpty()) {
            return;
        }
        Timestamp firstEntryBeforeTimestamp = this.cache.lowerKey(timeStamp);
        if (firstEntryBeforeTimestamp == null) {
            return;
        }
        Timestamp lastToDelete = this.cache.lowerKey(firstEntryBeforeTimestamp);
        if (lastToDelete == null) {
            return;
        }
        Timestamp firstKey = (Timestamp)this.cache.firstKey();
        while (firstKey.compareTo(lastToDelete) <= 0) {
            this.cache.remove(firstKey);
            firstKey = (Timestamp)this.cache.firstKey();
        }
    }

    private DoubleArrayTimeCache.Data data(Timestamp begin, Timestamp end) {
        return new Data(this.cache.subMap(begin, end), begin, end);
    }

    private <T extends Comparable<T>> T max(T a, T b) {
        if (a.compareTo(b) > 0) {
            return a;
        }
        return b;
    }

    private <T extends Comparable<T>> T min(T a, T b) {
        if (a.compareTo(b) < 0) {
            return a;
        }
        return b;
    }

    @Override
    public List<DoubleArrayTimeCache.Data> newData(Timestamp beginUpdate, Timestamp endUpdate, Timestamp beginNew, Timestamp endNew) {
        List<TimeInterval> updates = this.update();
        if (updates.isEmpty()) {
            return Collections.singletonList(this.data(this.cache.lowerKey(beginNew), endNew));
        }
        TimeInterval updateInterval = updates.get(0);
        Timestamp newBegin = this.max(beginUpdate, updateInterval.getStart());
        newBegin = this.min(newBegin, beginNew);
        this.deleteBefore(beginUpdate);
        return Collections.singletonList(this.data(newBegin, endNew));
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    public class Data
    implements DoubleArrayTimeCache.Data {
        private List<Timestamp> times = new ArrayList<Timestamp>();
        private List<ArrayDouble> arrays = new ArrayList<ArrayDouble>();
        private Timestamp begin;
        private Timestamp end;

        private Data(SortedMap<Timestamp, ArrayDouble> subMap, Timestamp begin, Timestamp end) {
            this.begin = begin;
            this.end = end;
            for (Map.Entry<Timestamp, ArrayDouble> en : subMap.entrySet()) {
                this.times.add(en.getKey());
                this.arrays.add(en.getValue());
            }
        }

        @Override
        public Timestamp getBegin() {
            return this.begin;
        }

        @Override
        public Timestamp getEnd() {
            return this.end;
        }

        @Override
        public int getNArrays() {
            return this.times.size();
        }

        @Override
        public ListNumber getArray(int index) {
            return (ListNumber)this.arrays.get(index);
        }

        @Override
        public Timestamp getTimestamp(int index) {
            return this.times.get(index);
        }
    }
}

