/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.extra.AdaptiveRange;
import org.epics.pvmanager.extra.ColorScheme;
import org.epics.pvmanager.extra.DoubleArrayTimeCache;
import org.epics.pvmanager.extra.WaterfallPlotParameters;
import org.epics.util.array.ListNumber;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;
import org.epics.vtype.Display;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

class WaterfallPlotFunction
implements ReadFunction<VImage> {
    private volatile WaterfallPlotParameters.InternalCopy mutableParameters;
    private WaterfallPlotParameters.InternalCopy previousParameters;
    private BufferedImage previousBuffer;
    private VImage previousImage;
    private Timestamp previousPlotEnd;
    private AdaptiveRange adaptiveRange;
    private DoubleArrayTimeCache doubleArrayTimeCache;

    public WaterfallPlotFunction(DoubleArrayTimeCache doubleArrayTimeCache, WaterfallPlotParameters.InternalCopy parameters) {
        this.doubleArrayTimeCache = doubleArrayTimeCache;
        this.mutableParameters = parameters;
    }

    public WaterfallPlotParameters.InternalCopy getParameters() {
        return this.mutableParameters;
    }

    public void setParameters(WaterfallPlotParameters.InternalCopy parameters) {
        this.mutableParameters = parameters;
    }

    private VImage drawImage() {
        int newWidth;
        DoubleArrayTimeCache.Data data;
        Timestamp plotEnd;
        int nNewPixels;
        boolean redrawAll;
        WaterfallPlotParameters.InternalCopy parameters = this.mutableParameters;
        if (parameters == null) {
            return null;
        }
        boolean bl = redrawAll = parameters != this.previousParameters;
        if (this.previousPlotEnd != null) {
            nNewPixels = Timestamp.now().durationFrom(this.previousPlotEnd).dividedBy(parameters.pixelDuration);
            plotEnd = this.previousPlotEnd.plus(parameters.pixelDuration.multipliedBy(nNewPixels));
        } else {
            plotEnd = Timestamp.now();
            nNewPixels = 0;
            redrawAll = true;
        }
        Timestamp plotStart = plotEnd.minus(parameters.pixelDuration.multipliedBy(parameters.height.intValue()));
        List<DoubleArrayTimeCache.Data> dataToPlot = redrawAll ? ((data = this.doubleArrayTimeCache.getData(plotStart, plotEnd)) != null && data.getNArrays() != 0 ? Collections.singletonList(data) : new ArrayList<DoubleArrayTimeCache.Data>()) : this.doubleArrayTimeCache.newData(plotStart, this.previousPlotEnd, this.previousPlotEnd, plotEnd);
        if (this.previousImage != null && nNewPixels == 0 && dataToPlot.isEmpty()) {
            return this.previousImage;
        }
        if (this.previousImage == null && dataToPlot.isEmpty()) {
            return null;
        }
        if (parameters.adaptiveRange.booleanValue()) {
            if (this.adaptiveRange == null) {
                this.adaptiveRange = new AdaptiveRange();
            }
        } else {
            this.adaptiveRange = null;
        }
        int newMaxArraySize = 0;
        for (DoubleArrayTimeCache.Data data2 : dataToPlot) {
            for (int n = 0; n < data2.getNArrays(); ++n) {
                ListNumber array = data2.getArray(n);
                newMaxArraySize = Math.max(newMaxArraySize, array.size());
                if (this.adaptiveRange == null) continue;
                this.adaptiveRange.considerValues(array);
            }
        }
        if (this.adaptiveRange != null && this.adaptiveRange.limitsChanged()) {
            DoubleArrayTimeCache.Data data3 = this.doubleArrayTimeCache.getData(plotStart, plotEnd);
            dataToPlot = Collections.singletonList(data3);
            redrawAll = true;
        }
        if ((newWidth = WaterfallPlotFunction.calculateNewWidth(this.previousBuffer, parameters, newMaxArraySize)) == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(newWidth, parameters.height, 5);
        if (this.previousImage != null && !redrawAll) {
            this.drawOldImage(image, this.previousBuffer, nNewPixels, parameters);
        } else if (parameters.backgroundColor != null) {
            Graphics2D gc = image.createGraphics();
            Color background = new Color(parameters.backgroundColor);
            gc.setColor(background);
            gc.fillRect(0, 0, newWidth, parameters.height);
            gc.dispose();
        }
        for (DoubleArrayTimeCache.Data data4 : dataToPlot) {
            int pixelsFromStart = 0;
            if (data4.getBegin().compareTo(plotStart) > 0) {
                pixelsFromStart = data4.getBegin().durationFrom(plotStart).dividedBy(parameters.pixelDuration);
            }
            int y = image.getHeight() - pixelsFromStart - 1;
            Timestamp pixelStart = plotStart.plus(parameters.pixelDuration.multipliedBy(pixelsFromStart));
            if (parameters.adaptiveRange.booleanValue()) {
                WaterfallPlotFunction.drawSection(image, parameters, null, this.adaptiveRange, parameters.colorScheme, data4, pixelStart, parameters.pixelDuration, y);
                continue;
            }
            WaterfallPlotFunction.drawSection(image, parameters, null, this.doubleArrayTimeCache.getDisplay(), parameters.colorScheme, data4, pixelStart, parameters.pixelDuration, y);
        }
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        this.previousBuffer = image;
        this.previousPlotEnd = plotEnd;
        this.previousParameters = parameters;
        return this.previousImage;
    }

    private static void drawSection(BufferedImage image, WaterfallPlotParameters.InternalCopy parameters, double[] positions, Display display, ColorScheme colorScheme, DoubleArrayTimeCache.Data data, Timestamp pixelStart, TimeDuration pixelDuration, int y) {
        int usedArrays = 0;
        Timestamp pixelEnd = pixelStart.plus(pixelDuration);
        while (pixelStart.compareTo(data.getEnd()) < 0) {
            List<ListNumber> pixelValues = WaterfallPlotFunction.valuesInPixel(pixelStart, pixelEnd, data, usedArrays);
            ListNumber dataToDisplay = WaterfallPlotFunction.aggregate(pixelValues);
            if (dataToDisplay == null) {
                WaterfallPlotFunction.copyPreviousLine(image, y, parameters);
            } else {
                WaterfallPlotFunction.drawLine(y, dataToDisplay, positions, display, colorScheme, image, parameters);
            }
            --y;
            pixelStart = pixelStart.plus(pixelDuration);
            pixelEnd = pixelStart.plus(pixelDuration);
        }
    }

    private static int calculateNewWidth(BufferedImage previousBuffer, WaterfallPlotParameters.InternalCopy parameters, int maxArraySize) {
        if (previousBuffer == null) {
            return maxArraySize;
        }
        return Math.max(previousBuffer.getWidth(), maxArraySize);
    }

    private static void copyPreviousLine(BufferedImage image, int y, WaterfallPlotParameters.InternalCopy parameters) {
        if (y < 0 || y >= image.getHeight()) {
            return;
        }
        int previousY = y + 1;
        if (previousY < 0 || previousY >= image.getHeight()) {
            return;
        }
        if (!parameters.scrollDown.booleanValue()) {
            y = parameters.height - y - 1;
            previousY = parameters.height - previousY - 1;
        }
        if (y >= 0 && y < image.getHeight()) {
            for (int x = 0; x < image.getWidth(); ++x) {
                image.setRGB(x, y, image.getRGB(x, previousY));
            }
        }
    }

    private static ListNumber aggregate(List<ListNumber> values) {
        if (values.isEmpty()) {
            return null;
        }
        return values.get(values.size() - 1);
    }

    private static List<ListNumber> valuesInPixel(Timestamp pixelStart, Timestamp pixelEnd, DoubleArrayTimeCache.Data data, int usedArrays) {
        ArrayList<ListNumber> pixelValues = new ArrayList<ListNumber>();
        for (int currentArray = usedArrays; currentArray < data.getNArrays() && data.getTimestamp(currentArray).compareTo(pixelEnd) <= 0; ++currentArray) {
            pixelValues.add(data.getArray(currentArray));
        }
        return pixelValues;
    }

    private static void drawLine(int y, ListNumber data, double[] positions, Display display, ColorScheme colorScheme, BufferedImage image, WaterfallPlotParameters.InternalCopy parameters) {
        if (positions != null) {
            throw new RuntimeException("Positions not supported yet");
        }
        if (y < 0 || y >= image.getHeight()) {
            return;
        }
        if (!parameters.scrollDown.booleanValue()) {
            y = parameters.height - y - 1;
        }
        for (int i = 0; i < data.size(); ++i) {
            image.setRGB(i, y, colorScheme.color(data.getDouble(i), display));
        }
    }

    public VImage readValue() {
        return this.drawImage();
    }

    private void drawOldImage(BufferedImage image, BufferedImage previousBuffer, int nNewPixels, WaterfallPlotParameters.InternalCopy parameters) {
        Graphics2D gc = image.createGraphics();
        if (parameters.scrollDown.booleanValue()) {
            gc.drawImage((Image)previousBuffer, 0, nNewPixels, null);
        } else {
            gc.drawImage((Image)previousBuffer, 0, -nNewPixels, null);
        }
        gc.dispose();
    }
}

