/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import org.epics.pvmanager.formula.AbstractVNumberArrayVNumberArrayToVNumberArrayFormulaFunction;
import org.epics.pvmanager.formula.AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction;
import org.epics.pvmanager.formula.AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction;
import org.epics.pvmanager.formula.ArrayOfNumberFormulaFunction;
import org.epics.pvmanager.formula.ArrayOfStringFormulaFunction;
import org.epics.pvmanager.formula.ArrayRangeOfFormulaFunction;
import org.epics.pvmanager.formula.ArrayWithBoundariesFormulaFunction;
import org.epics.pvmanager.formula.CaHistogramFormulaFunction;
import org.epics.pvmanager.formula.DftFormulaFunction;
import org.epics.pvmanager.formula.ElementAtNumberFormulaFunction;
import org.epics.pvmanager.formula.ElementAtStringFormulaFunction;
import org.epics.pvmanager.formula.FormulaFunctionSet;
import org.epics.pvmanager.formula.FormulaFunctionSetDescription;
import org.epics.pvmanager.formula.HistogramOfFormulaFunction;
import org.epics.pvmanager.formula.RescaleArrayFormulaFunction;
import org.epics.pvmanager.formula.SubArrayFormulaFunction;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;

public class ArrayFunctionSet
extends FormulaFunctionSet {
    public ArrayFunctionSet() {
        super(new FormulaFunctionSetDescription("array", "Aggregation and calculations on arrays").addFormulaFunction(new ArrayOfNumberFormulaFunction()).addFormulaFunction(new ArrayOfStringFormulaFunction()).addFormulaFunction(new ArrayWithBoundariesFormulaFunction()).addFormulaFunction(new AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction("arrayPow", "Result[x] = pow(array[x], expon)", "array", "expon"){

            @Override
            ListNumber calculate(ListNumber arg1, Number arg2) {
                return ListMath.pow((ListNumber)arg1, (double)arg2.doubleValue());
            }
        }).addFormulaFunction(new AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction("arrayPow", "Result[x] = pow(base, array[x])", "base", "array"){

            @Override
            ListNumber calculate(Number arg1, ListNumber arg2) {
                return ListMath.pow((double)arg1.doubleValue(), (ListNumber)arg2);
            }
        }).addFormulaFunction(new CaHistogramFormulaFunction()).addFormulaFunction(new HistogramOfFormulaFunction()).addFormulaFunction(new RescaleArrayFormulaFunction()).addFormulaFunction(new AbstractVNumberArrayVNumberArrayToVNumberArrayFormulaFunction("arrayMult", "Result[x] = array1[x] * array2[x]", "array1", "array2"){

            @Override
            ListNumber calculate(ListNumber array1, ListNumber array2) {
                return ListMath.multiply((ListNumber)array1, (ListNumber)array2);
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberArrayToVNumberArrayFormulaFunction("arrayDiv", "Result[x] = array1[x] / array2[x]", "array1", "array2"){

            @Override
            ListNumber calculate(ListNumber array1, ListNumber array2) {
                return ListMath.divide((ListNumber)array1, (ListNumber)array2);
            }
        }).addFormulaFunction(new SubArrayFormulaFunction()).addFormulaFunction(new ElementAtNumberFormulaFunction()).addFormulaFunction(new ElementAtStringFormulaFunction()).addFormulaFunction(new AbstractVNumberArrayVNumberArrayToVNumberArrayFormulaFunction("+", "Result[x] = array1[x] + array2[x]", "array1", "array2"){

            @Override
            ListNumber calculate(ListNumber array1, ListNumber array2) {
                return ListMath.add((ListNumber)array1, (ListNumber)array2);
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberArrayToVNumberArrayFormulaFunction("-", "Result[x] = array1[x] - array2[x]", "array1", "array2"){

            @Override
            ListNumber calculate(ListNumber array1, ListNumber array2) {
                return ListMath.subtract((ListNumber)array1, (ListNumber)array2);
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction("arraySum", "Result[x] = array[x] + offset", "array", "offset"){

            @Override
            ListNumber calculate(ListNumber array, Number offset) {
                return ListMath.rescale((ListNumber)array, (double)1.0, (double)offset.doubleValue());
            }
        }).addFormulaFunction(new AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction("arraySum", "Result[x] = offset + array[x]", "offset", "array"){

            @Override
            ListNumber calculate(Number offset, ListNumber array) {
                return ListMath.rescale((ListNumber)array, (double)1.0, (double)offset.doubleValue());
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction("arraySub", "Result[x] = array[x] - offset", "array", "offset"){

            @Override
            ListNumber calculate(ListNumber array, Number offset) {
                return ListMath.rescale((ListNumber)array, (double)1.0, (double)(-offset.doubleValue()));
            }
        }).addFormulaFunction(new AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction("arraySub", "Result[x] = offset - array[x]", "offset", "array"){

            @Override
            ListNumber calculate(Number offset, ListNumber array) {
                return ListMath.rescale((ListNumber)array, (double)-1.0, (double)offset.doubleValue());
            }
        }).addFormulaFunction(new AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction("arrayDiv", "Result[x] = num / array[x]", "num", "array"){

            @Override
            ListNumber calculate(Number numerator, ListNumber array) {
                return ListMath.inverseRescale((ListNumber)array, (double)numerator.doubleValue(), (double)0.0);
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction("*", "Result[x] = array[x] * num", "array", "num"){

            @Override
            ListNumber calculate(ListNumber array, Number num) {
                return ListMath.rescale((ListNumber)array, (double)num.doubleValue(), (double)0.0);
            }
        }).addFormulaFunction(new AbstractVNumberVNumberArrayToVNumberArrayFormulaFunction("*", "Result[x] = num * array[x]", "num", "array"){

            @Override
            ListNumber calculate(Number num, ListNumber array) {
                return ListMath.rescale((ListNumber)array, (double)num.doubleValue(), (double)0.0);
            }
        }).addFormulaFunction(new AbstractVNumberArrayVNumberToVNumberArrayFormulaFunction("arrayDiv", "Result[x] = array[x] / num", "array", "num"){

            @Override
            ListNumber calculate(ListNumber array, Number num) {
                return ListMath.rescale((ListNumber)array, (double)(1.0 / num.doubleValue()), (double)0.0);
            }
        }).addFormulaFunction(new DftFormulaFunction()).addFormulaFunction(new ArrayRangeOfFormulaFunction()));
    }
}

