/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class ArrayOfNumberFormulaFunction
implements FormulaFunction {
    ArrayOfNumberFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "arrayOf";
    }

    @Override
    public String getDescription() {
        return "Constructs array from a series of numbers";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumber.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("args");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    @Override
    public Object calculate(final List<Object> args) {
        ListDouble data = new ListDouble(){

            public double getDouble(int index) {
                VNumber number = (VNumber)args.get(index);
                if (number == null || number.getValue() == null) {
                    return Double.NaN;
                }
                return number.getValue().doubleValue();
            }

            public int size() {
                return args.size();
            }
        };
        return ValueFactory.newVNumberArray((ListNumber)data, (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args), (Display)ValueFactory.displayNone());
    }
}

