/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.util.NullUtils;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.table.ListNumberProvider;

class ArrayWithBoundariesFormulaFunction
implements FormulaFunction {
    ArrayWithBoundariesFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "arrayWithBoundaries";
    }

    @Override
    public String getDescription() {
        return "Returns an array with the given values and cell boundaries";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumberArray.class, ListNumberProvider.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("dataArray", "boundaries");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        if (NullUtils.containsNull(args)) {
            return null;
        }
        VNumberArray array = (VNumberArray)args.get(0);
        if (array.getSizes().size() != args.size() - 1) {
            throw new IllegalArgumentException("Dimension of the array must match the number of ListNumberProvider");
        }
        ArrayList<ArrayDimensionDisplay> dimDisplay = new ArrayList<ArrayDimensionDisplay>();
        for (int i = 1; i < args.size(); ++i) {
            ListNumberProvider numberGenerator = (ListNumberProvider)args.get(i);
            dimDisplay.add(ValueFactory.newDisplay((ListNumber)numberGenerator.createListNumber(array.getSizes().getInt(i - 1) + 1), (String)""));
        }
        return ValueFactory.newVNumberArray((ListNumber)array.getData(), (ListInt)array.getSizes(), dimDisplay, (Alarm)array, (Time)array, (Display)array);
    }
}

