/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.DynamicFormulaFunction;
import org.epics.pvmanager.formula.LastOfChannelExpression;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VString;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.table.VTableFactory;

class CaHistogramFormulaFunction
extends DynamicFormulaFunction {
    private String previousName;
    private List<DesiredRateExpression<?>> currentExpressions;

    CaHistogramFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "caHistogram";
    }

    @Override
    public String getDescription() {
        return "Returns an array with boundary that corresponds to an EPICS v3 histogram record";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("channelName");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    Object calculateImpl(String newName) {
        if (!Objects.equals(newName, this.previousName)) {
            if (this.currentExpressions != null) {
                for (DesiredRateExpression<?> desiredRateExpression : this.currentExpressions) {
                    if (desiredRateExpression == null) continue;
                    this.getDirector().disconnectExpression(desiredRateExpression);
                }
            }
            ArrayList newExpressions = new ArrayList();
            if (newName != null) {
                newExpressions.addAll(Collections.nCopies(3, null));
            }
            if (newName != null) {
                LastOfChannelExpression<Object> newExpression = new LastOfChannelExpression<Object>(newName, Object.class);
                this.getDirector().connectExpression(newExpression);
                newExpressions.set(0, newExpression);
                newExpression = new LastOfChannelExpression<Object>(newName + ".LLIM", Object.class);
                this.getDirector().connectExpression(newExpression);
                newExpressions.set(1, newExpression);
                newExpression = new LastOfChannelExpression<Object>(newName + ".ULIM", Object.class);
                this.getDirector().connectExpression(newExpression);
                newExpressions.set(2, newExpression);
            }
            this.previousName = newName;
            this.currentExpressions = newExpressions;
        }
        if (newName == null) {
            return null;
        }
        VNumberArray array = (VNumberArray)this.currentExpressions.get(0).getFunction().readValue();
        VNumber lowerRange = (VNumber)this.currentExpressions.get(1).getFunction().readValue();
        VNumber upperRange = (VNumber)this.currentExpressions.get(2).getFunction().readValue();
        if (array == null || lowerRange == null || upperRange == null) {
            return null;
        }
        return ValueFactory.newVNumberArray((ListNumber)array.getData(), (ListInt)array.getSizes(), Arrays.asList(ValueFactory.newDisplay((ListNumber)VTableFactory.range((double)lowerRange.getValue().doubleValue(), (double)upperRange.getValue().doubleValue()).createListNumber(array.getSizes().getInt(0) + 1), (String)"")), (Alarm)array, (Time)array, (Display)array);
    }

    @Override
    public Object calculate(List<Object> args) {
        VString value = (VString)args.get(0);
        String newName = null;
        if (value != null) {
            newName = value.getValue();
        }
        return this.calculateImpl(newName);
    }

    @Override
    public void dispose() {
        for (DesiredRateExpression<?> desiredRateExpression : new HashSet(this.currentExpressions)) {
            this.getDirector().disconnectExpression(desiredRateExpression);
        }
        this.currentExpressions = null;
        this.previousName = null;
    }
}

