/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInt;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VString;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.ValueFactory;

class ColumnOfVTableFunction
implements FormulaFunction {
    ColumnOfVTableFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "columnOf";
    }

    @Override
    public String getDescription() {
        return "Extracts a column from the given table";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VTable.class, VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("table", "columName");
    }

    @Override
    public Class<?> getReturnType() {
        return VType.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VTable table = (VTable)args.get(0);
        VString columnName = (VString)args.get(1);
        if (columnName == null || table == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!Objects.equals(columnName.getValue(), table.getColumnName(i))) continue;
            index = i;
        }
        if (index == -1) {
            throw new RuntimeException("Table does not contain column '" + columnName.getValue() + "'");
        }
        Class type = table.getColumnType(index);
        if (String.class.isAssignableFrom(type)) {
            List data = (List)table.getColumnData(index);
            return ValueFactory.newVStringArray((List)data, (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow());
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            ListDouble data = (ListDouble)table.getColumnData(index);
            return ValueFactory.newVDoubleArray((ListDouble)data, (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow(), (Display)ValueFactory.displayNone());
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            ListInt data = (ListInt)table.getColumnData(index);
            return ValueFactory.newVIntArray((ListInt)data, (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow(), (Display)ValueFactory.displayNone());
        }
        throw new RuntimeException("Unsupported type " + type.getSimpleName());
    }
}

