/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Collection;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.DesiredRateExpressionImpl;
import org.epics.pvmanager.expression.DesiredRateExpressionList;
import org.epics.pvmanager.expression.DesiredRateExpressionListImpl;
import org.epics.pvmanager.expression.DesiredRateReadWriteExpression;
import org.epics.pvmanager.expression.DesiredRateReadWriteExpressionImpl;
import org.epics.pvmanager.expression.Expressions;
import org.epics.pvmanager.expression.WriteExpression;
import org.epics.pvmanager.formula.ErrorDesiredRateExpression;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.formula.FormulaFunctionReadExpression;
import org.epics.pvmanager.formula.FormulaFunctions;
import org.epics.pvmanager.formula.FormulaLexer;
import org.epics.pvmanager.formula.FormulaParser;
import org.epics.pvmanager.formula.FormulaReadFunction;
import org.epics.pvmanager.formula.FormulaRegistry;
import org.epics.pvmanager.formula.LastOfChannelExpression;
import org.epics.pvmanager.formula.ReadOnlyWriteExpression;
import org.epics.util.text.StringUtil;
import org.epics.vtype.ValueUtil;

public class ExpressionLanguage {
    private ExpressionLanguage() {
    }

    static FormulaParser createParser(String text) {
        ANTLRStringStream stream = new ANTLRStringStream(text);
        FormulaLexer lexer = new FormulaLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        return new FormulaParser((TokenStream)tokenStream);
    }

    public static String channelFromFormula(String formula) {
        if (!formula.startsWith("=")) {
            if (formula.trim().matches("'([^\"\\\\]|\\\\(\"|\\\\|'|r|n|b|t|u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]|[0-3]?[0-7]?[0-7]))*'")) {
                return StringUtil.unquote((String)formula);
            }
            return formula;
        }
        formula = formula.substring(1);
        try {
            FormulaParser parser = ExpressionLanguage.createParser(formula);
            DesiredRateExpression<?> exp = parser.singlePv();
            if (parser.failed()) {
                return null;
            }
            if (exp instanceof LastOfChannelExpression) {
                LastOfChannelExpression channelExp = (LastOfChannelExpression)exp;
                return channelExp.getName();
            }
            return null;
        }
        catch (RecognitionException ex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static DesiredRateReadWriteExpression<?, Object> formula(String formula) {
        DesiredRateExpression<?> exp = ExpressionLanguage.parseFormula(formula);
        if (exp instanceof LastOfChannelExpression) {
            return new DesiredRateReadWriteExpressionImpl(exp, (WriteExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vType((String)exp.getName()));
        }
        if (exp instanceof ErrorDesiredRateExpression) {
            return new DesiredRateReadWriteExpressionImpl(exp, ExpressionLanguage.readOnlyWriteExpression("Parsing error"));
        }
        return new DesiredRateReadWriteExpressionImpl(exp, ExpressionLanguage.readOnlyWriteExpression("Read-only formula"));
    }

    private static DesiredRateExpression<?> parseFormula(String formula) {
        IllegalArgumentException parsingError;
        if (!formula.startsWith("=")) {
            return ExpressionLanguage.cachedPv(ExpressionLanguage.channelFromFormula(formula));
        }
        formula = formula.substring(1);
        try {
            DesiredRateExpression<?> exp = ExpressionLanguage.createParser(formula).formula();
            if (exp == null) {
                throw new NullPointerException("Parsing failed");
            }
            return exp;
        }
        catch (RecognitionException ex) {
            parsingError = new IllegalArgumentException("Error parsing formula: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            parsingError = new IllegalArgumentException("Malformed formula '" + formula + "'", ex);
        }
        return ExpressionLanguage.errorDesiredRateExpression(parsingError);
    }

    public static DesiredRateExpression<?> formulaArg(String formula) {
        if (formula == null || formula.trim().isEmpty()) {
            return null;
        }
        return ExpressionLanguage.parseFormula(formula);
    }

    public static <T> DesiredRateExpression<T> formula(String formula, Class<T> readType) {
        DesiredRateExpression<?> exp = ExpressionLanguage.parseFormula(formula);
        return ExpressionLanguage.checkReturnType(readType, "Value", exp);
    }

    static DesiredRateExpression<?> cachedPv(String channelName) {
        return new LastOfChannelExpression<Object>(channelName, Object.class);
    }

    static <T> DesiredRateExpression<T> cast(Class<T> clazz, DesiredRateExpression<?> arg1) {
        if (arg1 instanceof LastOfChannelExpression) {
            return ((LastOfChannelExpression)arg1).cast(clazz);
        }
        DesiredRateExpression<?> op1 = arg1;
        return op1;
    }

    static <T> DesiredRateExpressionList<T> cast(Class<T> clazz, DesiredRateExpressionList<?> args) {
        for (DesiredRateExpression desiredRateExpression : args.getDesiredRateExpressions()) {
            ExpressionLanguage.cast(clazz, desiredRateExpression);
        }
        DesiredRateExpressionList<?> op1 = args;
        return op1;
    }

    static String opName(String op, DesiredRateExpression<?> arg1, DesiredRateExpression<?> arg2) {
        return "(" + arg1.getName() + op + arg2.getName() + ")";
    }

    static String opName(String op, DesiredRateExpression<?> arg) {
        return op + arg.getName();
    }

    static String funName(String fun, DesiredRateExpression<?> arg) {
        return fun + "(" + arg.getName() + ")";
    }

    static DesiredRateExpression<?> powCast(DesiredRateExpression<?> arg1, DesiredRateExpression<?> arg2) {
        return ExpressionLanguage.function("^", new DesiredRateExpressionListImpl().and(arg1).and(arg2));
    }

    static DesiredRateExpression<?> threeArgOp(String opName, DesiredRateExpression<?> arg1, DesiredRateExpression<?> arg2, DesiredRateExpression<?> arg3) {
        return ExpressionLanguage.function(opName, new DesiredRateExpressionListImpl().and(arg1).and(arg2).and(arg3));
    }

    static DesiredRateExpression<?> twoArgOp(String opName, DesiredRateExpression<?> arg1, DesiredRateExpression<?> arg2) {
        return ExpressionLanguage.function(opName, new DesiredRateExpressionListImpl().and(arg1).and(arg2));
    }

    static DesiredRateExpression<?> oneArgOp(String opName, DesiredRateExpression<?> arg) {
        return ExpressionLanguage.function(opName, new DesiredRateExpressionListImpl().and(arg));
    }

    static DesiredRateExpression<?> function(String function, DesiredRateExpressionList<?> args) {
        Collection<FormulaFunction> matchedFunctions = FormulaRegistry.getDefault().findFunctions(function, args.getDesiredRateExpressions().size());
        if (matchedFunctions.size() > 0) {
            FormulaReadFunction readFunction = new FormulaReadFunction(Expressions.functionsOf(args), matchedFunctions);
            ArrayList<String> argNames = new ArrayList<String>(args.getDesiredRateExpressions().size());
            for (DesiredRateExpression arg : args.getDesiredRateExpressions()) {
                argNames.add(arg.getName());
            }
            return new FormulaFunctionReadExpression(args, readFunction, FormulaFunctions.format(function, argNames));
        }
        throw new IllegalArgumentException("No function named '" + function + "' is defined");
    }

    static <T> WriteExpression<T> readOnlyWriteExpression(String errorMessage) {
        return new ReadOnlyWriteExpression(errorMessage, "");
    }

    static <T> DesiredRateExpression<T> errorDesiredRateExpression(RuntimeException error) {
        return new ErrorDesiredRateExpression(error, "");
    }

    static <T> DesiredRateExpression<T> checkReturnType(final Class<T> clazz, final String argName, final DesiredRateExpression<?> arg1) {
        return new DesiredRateExpressionImpl(arg1, new ReadFunction<T>(){

            public T readValue() {
                Object obj = arg1.getFunction().readValue();
                if (obj == null) {
                    return null;
                }
                if (clazz.isInstance(obj)) {
                    return clazz.cast(obj);
                }
                throw new RuntimeException(argName + " must be a " + clazz.getSimpleName() + " (was " + ValueUtil.typeOf((Object)obj).getSimpleName() + ")");
            }
        }, arg1.getName());
    }
}

