/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.formula.FormulaFunctionSet;
import org.epics.pvmanager.formula.FormulaFunctions;

public class FormulaRegistry {
    private static final FormulaRegistry registry = new FormulaRegistry();
    private Map<String, FormulaFunctionSet> functionSets = new ConcurrentHashMap<String, FormulaFunctionSet>();
    private Map<String, Map<Integer, Collection<FormulaFunction>>> formulaFunctions = new ConcurrentHashMap<String, Map<Integer, Collection<FormulaFunction>>>();

    public static FormulaRegistry getDefault() {
        return registry;
    }

    public void registerFormulaFunctionSet(FormulaFunctionSet functionSet) {
        this.functionSets.put(functionSet.getName(), functionSet);
        for (FormulaFunction formulaFunction : functionSet.getFunctions()) {
            this.registerFormulaFunction(formulaFunction);
        }
    }

    private void registerFormulaFunction(FormulaFunction formulaFunction) {
        Collection<FormulaFunction> functionsForNArguments;
        Map<Integer, Collection<FormulaFunction>> functionForName = this.formulaFunctions.get(formulaFunction.getName());
        if (functionForName == null) {
            functionForName = new ConcurrentHashMap<Integer, Collection<FormulaFunction>>();
            this.formulaFunctions.put(formulaFunction.getName(), functionForName);
        }
        if ((functionsForNArguments = functionForName.get(formulaFunction.getArgumentNames().size())) == null) {
            functionsForNArguments = Collections.newSetFromMap(new ConcurrentHashMap());
            functionForName.put(formulaFunction.getArgumentNames().size(), functionsForNArguments);
        }
        functionsForNArguments.add(formulaFunction);
    }

    public Set<String> listFunctionSets() {
        return Collections.unmodifiableSet(new HashSet<String>(this.functionSets.keySet()));
    }

    public FormulaFunctionSet findFunctionSet(String name) {
        return this.functionSets.get(name);
    }

    public Collection<FormulaFunction> findFunctions(String functionName, Integer nArguments) {
        HashSet<FormulaFunction> functions = new HashSet<FormulaFunction>();
        for (FormulaFunctionSet formulaFunctionSet : this.functionSets.values()) {
            for (FormulaFunction formulaFunction : formulaFunctionSet.getFunctions()) {
                if (!formulaFunction.getName().equals(functionName) || !FormulaFunctions.matchArgumentCount(nArguments, formulaFunction)) continue;
                functions.add(formulaFunction);
            }
        }
        return functions;
    }
}

