/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.StatefulFormulaFunction;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;
import org.epics.util.text.NumberFormats;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueFactory;

class HistogramOfFormulaFunction
extends StatefulFormulaFunction {
    private VNumberArray previousValue;
    private VNumberArray previousResult;
    private double previousMaxCount;
    private Range previousXRange;

    HistogramOfFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "histogramOf";
    }

    @Override
    public String getDescription() {
        return "Returns a histograms of the elements in the array.";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumberArray.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("Array", "index");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumber.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumberArray numberArray = (VNumberArray)args.get(0);
        if (numberArray == null) {
            return null;
        }
        if (this.previousValue == numberArray) {
            return this.previousResult;
        }
        Statistics stats = StatisticsUtil.statisticsOf((CollectionNumber)numberArray.getData());
        int nBins = 100;
        Range aggregatedRange = Ranges.aggregateRange((Range)stats, (Range)this.previousXRange);
        Object xRange = Ranges.overlap((Range)stats, (Range)aggregatedRange) >= 0.75 ? aggregatedRange : stats;
        IteratorNumber newValues = numberArray.getData().iterator();
        double minValueRange = xRange.getMinimum().doubleValue();
        double maxValueRange = xRange.getMaximum().doubleValue();
        ListNumber xBoundaries = ListNumbers.linearListFromRange((double)minValueRange, (double)maxValueRange, (int)(nBins + 1));
        String unit = numberArray.getUnits();
        int[] binData = new int[nBins];
        double maxCount = 0.0;
        while (newValues.hasNext()) {
            double value = newValues.nextDouble();
            if (!Ranges.contains((Range)xRange, (double)value)) continue;
            int bin = (int)Math.floor(Ranges.normalize((Range)xRange, (double)value) * (double)nBins);
            if (bin == nBins) {
                // empty if block
            }
            int n = --bin;
            binData[n] = binData[n] + 1;
            if (!((double)binData[bin] > maxCount)) continue;
            maxCount = binData[bin];
        }
        if (this.previousMaxCount > maxCount && this.previousMaxCount < maxCount * 2.0) {
            maxCount = this.previousMaxCount;
        }
        this.previousMaxCount = maxCount;
        this.previousXRange = xRange;
        this.previousValue = numberArray;
        this.previousResult = ValueFactory.newVNumberArray((ListNumber)new ArrayInt(binData), (ListInt)new ArrayInt(new int[]{nBins}), Arrays.asList(ValueFactory.newDisplay((ListNumber)xBoundaries, (String)unit)), (Alarm)numberArray, (Time)numberArray, (Display)ValueFactory.newDisplay((Double)0.0, (Double)0.0, (Double)0.0, (String)"count", (NumberFormat)NumberFormats.format((int)0), (Double)maxCount, (Double)maxCount, (Double)maxCount, (Double)Double.NaN, (Double)Double.NaN));
        return this.previousResult;
    }
}

