/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.util.ArrayList;
import java.util.List;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExceptionHandler;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.ReadRecipe;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.DesiredRateExpressionImpl;
import org.epics.pvmanager.expression.DesiredRateExpressionList;
import org.epics.pvmanager.expression.DesiredRateExpressionListImpl;
import org.epics.pvmanager.extra.DynamicGroupFunction;

public class DynamicGroup
extends DesiredRateExpressionImpl<List<Object>> {
    private final DataSource dataSource = PVManager.getDefaultDataSource();
    private final List<ReadRecipe> recipes = new ArrayList<ReadRecipe>();

    public DynamicGroup() {
        super((DesiredRateExpressionList)new DesiredRateExpressionListImpl(), (ReadFunction)new DynamicGroupFunction(), "dynamic group");
    }

    DynamicGroupFunction getGroup() {
        return (DynamicGroupFunction)this.getFunction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Exception> lastExceptions() {
        DynamicGroupFunction dynamicGroupFunction = this.getGroup();
        synchronized (dynamicGroupFunction) {
            return new ArrayList<Exception>(this.getGroup().getExceptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DynamicGroup clear() {
        for (int index = this.recipes.size() - 1; index >= 0; --index) {
            ReadRecipe recipe = this.recipes.remove(index);
            this.dataSource.disconnectRead(recipe);
            DynamicGroupFunction dynamicGroupFunction = this.getGroup();
            synchronized (dynamicGroupFunction) {
                this.getGroup().getArguments().remove(index);
                this.getGroup().getExceptions().remove(index);
                this.getGroup().getPreviousValues().remove(index);
                continue;
            }
        }
        return this;
    }

    public synchronized int size() {
        return this.recipes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DynamicGroup add(DesiredRateExpression<?> expression) {
        DynamicGroupFunction dynamicGroupFunction = this.getGroup();
        synchronized (dynamicGroupFunction) {
            this.getGroup().getArguments().add(expression.getFunction());
            this.getGroup().getExceptions().add(null);
            this.getGroup().getPreviousValues().add(null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DynamicGroup remove(int index) {
        ReadRecipe recipe = this.recipes.remove(index);
        this.dataSource.disconnectRead(recipe);
        DynamicGroupFunction dynamicGroupFunction = this.getGroup();
        synchronized (dynamicGroupFunction) {
            this.getGroup().getArguments().remove(index);
            this.getGroup().getExceptions().remove(index);
            this.getGroup().getPreviousValues().remove(index);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DynamicGroup set(int index, DesiredRateExpression<?> expression) {
        ReadRecipe oldRecipe = this.recipes.get(index);
        this.dataSource.disconnectRead(oldRecipe);
        DynamicGroupFunction dynamicGroupFunction = this.getGroup();
        synchronized (dynamicGroupFunction) {
            this.getGroup().getArguments().set(index, expression.getFunction());
            this.getGroup().getExceptions().set(index, null);
            this.getGroup().getPreviousValues().set(index, null);
        }
        return this;
    }

    private ExceptionHandler handlerFor(final int index) {
        return new ExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleException(Exception ex) {
                DynamicGroupFunction dynamicGroupFunction = DynamicGroup.this.getGroup();
                synchronized (dynamicGroupFunction) {
                    DynamicGroup.this.getGroup().getExceptions().set(index, ex);
                }
            }
        };
    }
}

