/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvmanager.extra.ColorScheme;
import org.epics.pvmanager.extra.Parameters;
import org.epics.util.time.TimeDuration;

public class WaterfallPlotParameters
extends Parameters {
    WaterfallPlotParameters(Object name, Object value) {
        super(Collections.singletonMap(name, value));
    }

    WaterfallPlotParameters(Map<Object, Object> map) {
        super(map);
    }

    WaterfallPlotParameters(WaterfallPlotParameters defaults, WaterfallPlotParameters ... newValues) {
        super(defaults, newValues);
    }

    public static WaterfallPlotParameters defaults() {
        HashMap<Object, Object> defaults = new HashMap<Object, Object>();
        defaults.put("height", 50);
        defaults.put("colorScheme", ColorScheme.singleRangeGradient(Color.BLACK, Color.WHITE));
        defaults.put("adaptiveRange", false);
        defaults.put("scrollDown", false);
        defaults.put("pixelDuration", TimeDuration.ofMillis((int)10));
        return new WaterfallPlotParameters(defaults);
    }

    InternalCopy internalCopy() {
        return new InternalCopy(this.getParameters());
    }

    public static WaterfallPlotParameters height(int height) {
        return new WaterfallPlotParameters("height", height);
    }

    public static WaterfallPlotParameters colorScheme(ColorScheme colorScheme) {
        return new WaterfallPlotParameters("colorScheme", colorScheme);
    }

    public static WaterfallPlotParameters adaptiveRange(boolean adaptiveRange) {
        return new WaterfallPlotParameters("adaptiveRange", adaptiveRange);
    }

    public static WaterfallPlotParameters scrollDown(boolean scrollDown) {
        return new WaterfallPlotParameters("scrollDown", scrollDown);
    }

    public static WaterfallPlotParameters pixelDuration(TimeDuration pixelDuration) {
        return new WaterfallPlotParameters("pixelDuration", pixelDuration);
    }

    public static WaterfallPlotParameters backgroundColor(int rgb) {
        return new WaterfallPlotParameters("backgroundColor", rgb);
    }

    public WaterfallPlotParameters with(WaterfallPlotParameters ... newParameters) {
        return new WaterfallPlotParameters(this, newParameters);
    }

    public int getHeight() {
        return this.internalCopy().height;
    }

    public boolean isAdaptiveRange() {
        return this.internalCopy().adaptiveRange;
    }

    public boolean isScrollDown() {
        return this.internalCopy().scrollDown;
    }

    public ColorScheme getColorScheme() {
        return this.internalCopy().colorScheme;
    }

    public TimeDuration getPixelDuration() {
        return this.internalCopy().pixelDuration;
    }

    static class InternalCopy {
        final Integer height;
        final ColorScheme colorScheme;
        final Boolean adaptiveRange;
        final Boolean scrollDown;
        final TimeDuration pixelDuration;
        final Integer backgroundColor;

        private InternalCopy(Map<Object, Object> params) {
            this.height = (Integer)params.get("height");
            this.colorScheme = (ColorScheme)params.get("colorScheme");
            this.adaptiveRange = (Boolean)params.get("adaptiveRange");
            this.scrollDown = (Boolean)params.get("scrollDown");
            this.pixelDuration = (TimeDuration)params.get("pixelDuration");
            this.backgroundColor = (Integer)params.get("backgroundColor");
        }
    }
}

