/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.util.NullUtils;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class ArrayRangeOfFormulaFunction
implements FormulaFunction {
    ArrayRangeOfFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "arrayRangeOf";
    }

    @Override
    public String getDescription() {
        return "Returns the range where the array is defined";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumberArray.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("array");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        if (NullUtils.containsNull(args)) {
            return null;
        }
        VNumberArray numberArray = (VNumberArray)args.get(0);
        double min = ((ArrayDimensionDisplay)numberArray.getDimensionDisplay().get(0)).getCellBoundaries().getDouble(0);
        double max = ((ArrayDimensionDisplay)numberArray.getDimensionDisplay().get(0)).getCellBoundaries().getDouble(numberArray.getSizes().getInt(0));
        return ValueFactory.newVNumberArray((ListNumber)new ArrayDouble(new double[]{min, max}), (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args), (Display)ValueFactory.displayNone());
    }
}

