/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.Time;
import org.epics.vtype.VString;
import org.epics.vtype.VStringArray;
import org.epics.vtype.ValueFactory;

class ConcatStringArrayFunction
implements FormulaFunction {
    ConcatStringArrayFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "concat";
    }

    @Override
    public String getDescription() {
        return "Concatenate the strings of the given string array ";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VStringArray.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("stringArray");
    }

    @Override
    public Class<?> getReturnType() {
        return VString.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VStringArray stringArray = (VStringArray)args.get(0);
        if (stringArray == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String str : stringArray.getData()) {
            sb.append(str);
        }
        return ValueFactory.newVString((String)sb.toString(), (Alarm)stringArray, (Time)stringArray);
    }
}

