/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.Time;
import org.epics.vtype.VString;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class ConcatStringsFunction
implements FormulaFunction {
    ConcatStringsFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "concat";
    }

    @Override
    public String getDescription() {
        return "Concatenate the strings";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("string");
    }

    @Override
    public Class<?> getReturnType() {
        return VString.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        StringBuffer sb = new StringBuffer();
        for (Object object : args) {
            VString str = (VString)object;
            if (str == null) {
                return null;
            }
            sb.append(str.getValue());
        }
        return ValueFactory.newVString((String)sb.toString(), (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args));
    }
}

