/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueFactory;

class DftFormulaFunction
implements FormulaFunction {
    DftFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "dft";
    }

    @Override
    public String getDescription() {
        return "(Experimental) DFT of the argument";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumberArray.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("array1D");
    }

    @Override
    public Class<?> getReturnType() {
        return VTable.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumberArray array = (VNumberArray)args.get(0);
        if (array == null) {
            return null;
        }
        if (array.getSizes().size() != 1) {
            throw new IllegalArgumentException("Only 1D array supported for DFT");
        }
        List fft = ListMath.dft((ListNumber)array.getData(), (ListNumber)new ArrayDouble(new double[array.getData().size()]));
        final ListNumber real = (ListNumber)fft.get(0);
        final ListNumber imaginary = (ListNumber)fft.get(1);
        ListDouble modulus = new ListDouble(){

            public double getDouble(int index) {
                double x = real.getDouble(index);
                double y = imaginary.getDouble(index);
                if (x != 0.0 || y != 0.0) {
                    return Math.sqrt(x * x + y * y);
                }
                return 0.0;
            }

            public int size() {
                return real.size();
            }
        };
        ListDouble phase = new ListDouble(){

            public double getDouble(int index) {
                double x = real.getDouble(index);
                double y = imaginary.getDouble(index);
                return Math.atan2(y, x);
            }

            public int size() {
                return real.size();
            }
        };
        return ValueFactory.newVTable(Arrays.asList(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE), Arrays.asList("x", "y", "mod", "phase"), Arrays.asList(real, imaginary, modulus, phase));
    }
}

