/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.VBoolean;
import org.epics.vtype.VNumber;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.table.ListNumberProvider;
import org.epics.vtype.table.VTableFactory;

class DimDisplayFormulaFunction
implements FormulaFunction {
    DimDisplayFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "dimDisplay";
    }

    @Override
    public String getDescription() {
        return "Gathers information for one dimension of an nd array";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumber.class, VBoolean.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("size", "invert");
    }

    @Override
    public Class<?> getReturnType() {
        return ArrayDimensionDisplay.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumber size = (VNumber)args.get(0);
        VBoolean invert = (VBoolean)args.get(1);
        if (size == null || invert == null) {
            return null;
        }
        return ValueFactory.newDisplay((int)size.getValue().intValue(), (ListNumberProvider)VTableFactory.step((double)0.0, (double)1.0), (boolean)invert.getValue());
    }
}

