/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.Time;
import org.epics.vtype.VEnum;
import org.epics.vtype.VType;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class HighestSeverityFunction
implements FormulaFunction {
    HighestSeverityFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "highestSeverity";
    }

    @Override
    public String getDescription() {
        return "Returns the highest severity";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VType.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("values");
    }

    @Override
    public Class<?> getReturnType() {
        return VEnum.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        Alarm alarm = ValueUtil.highestSeverityOf(args, (boolean)true);
        Time time = ValueUtil.timeOf((Object)alarm);
        if (time == null) {
            time = ValueFactory.timeNow();
        }
        return ValueFactory.newVEnum((int)alarm.getAlarmSeverity().ordinal(), (List)AlarmSeverity.labels(), (Alarm)alarm, (Time)time);
    }
}

