/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.StatefulFormulaFunction;
import org.epics.pvmanager.util.NullUtils;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;
import org.epics.util.text.NumberFormats;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VString;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class Histogram2DOfFormulaFunction
extends StatefulFormulaFunction {
    private ListNumber previousXData;
    private ListNumber previousYData;
    private VNumberArray previousResult;
    private double previousMaxCount;
    private Range previousXRange;
    private Range previousYRange;

    Histogram2DOfFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "histogram2DOf";
    }

    @Override
    public String getDescription() {
        return "Returns a 2D histogram from a table.";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VTable.class, VString.class, VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("Table", "Y Column", "X Column");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        if (NullUtils.containsNull(args)) {
            return null;
        }
        VTable table = (VTable)args.get(0);
        VString yColumnName = (VString)args.get(1);
        VString xColumnName = (VString)args.get(2);
        ListNumber yData = ValueUtil.numericColumnOf((VTable)table, (String)yColumnName.getValue());
        ListNumber xData = ValueUtil.numericColumnOf((VTable)table, (String)xColumnName.getValue());
        int nPoints = Math.min(yData.size(), xData.size());
        Statistics xStats = StatisticsUtil.statisticsOf((CollectionNumber)xData);
        Statistics yStats = StatisticsUtil.statisticsOf((CollectionNumber)yData);
        int nXBins = 20;
        int nYBins = 20;
        Range aggregatedXRange = Ranges.aggregateRange((Range)xStats, (Range)this.previousXRange);
        Range aggregatedYRange = Ranges.aggregateRange((Range)yStats, (Range)this.previousYRange);
        Object xRange = Ranges.overlap((Range)aggregatedXRange, (Range)xStats) >= 0.9 ? aggregatedXRange : xStats;
        Object yRange = Ranges.overlap((Range)aggregatedYRange, (Range)yStats) >= 0.9 ? aggregatedYRange : yStats;
        double minXValueRange = xRange.getMinimum().doubleValue();
        double maxXValueRange = xRange.getMaximum().doubleValue();
        double minYValueRange = yRange.getMinimum().doubleValue();
        double maxYValueRange = yRange.getMaximum().doubleValue();
        ListNumber xBoundaries = ListNumbers.linearListFromRange((double)minXValueRange, (double)maxXValueRange, (int)(nXBins + 1));
        ListNumber yBoundaries = ListNumbers.linearListFromRange((double)minYValueRange, (double)maxYValueRange, (int)(nYBins + 1));
        int[] binData = new int[nXBins * nYBins];
        double maxCount = 0.0;
        for (int i = 0; i < nPoints; ++i) {
            int binIndex;
            double xValue = xData.getDouble(i);
            double yValue = yData.getDouble(i);
            if (!Ranges.contains((Range)xRange, (double)xValue) || !Ranges.contains((Range)yRange, (double)yValue)) continue;
            int xBin = (int)Math.floor(Ranges.normalize((Range)xRange, (double)xValue) * (double)nXBins);
            int yBin = (int)Math.floor(Ranges.normalize((Range)yRange, (double)yValue) * (double)nYBins);
            if (xBin == nXBins) {
                --xBin;
            }
            if (yBin == nYBins) {
                --yBin;
            }
            int n = binIndex = yBin * nXBins + xBin;
            binData[n] = binData[n] + 1;
            if (!((double)binData[binIndex] > maxCount)) continue;
            maxCount = binData[binIndex];
        }
        if (this.previousMaxCount > maxCount && (this.previousMaxCount < maxCount * 2.0 || maxCount < 9.0)) {
            maxCount = this.previousMaxCount;
        }
        this.previousMaxCount = maxCount;
        this.previousXRange = xRange;
        this.previousXData = xData;
        this.previousYData = yData;
        this.previousResult = ValueFactory.newVNumberArray((ListNumber)new ArrayInt(binData), (ListInt)new ArrayInt(new int[]{nYBins, nXBins}), Arrays.asList(ValueFactory.newDisplay((ListNumber)yBoundaries, (String)""), ValueFactory.newDisplay((ListNumber)xBoundaries, (String)"")), (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow(), (Display)ValueFactory.newDisplay((Double)0.0, (Double)0.0, (Double)0.0, (String)"count", (NumberFormat)NumberFormats.format((int)0), (Double)maxCount, (Double)maxCount, (Double)maxCount, (Double)Double.NaN, (Double)Double.NaN));
        return this.previousResult;
    }
}

